<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createAboAboNawRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Aanmaken van een nieuw abonnement voor een relatie, waarbij de NAW gegevens van de relatie meegegeven kan worden.
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class CreateAboAboNawRequest extends AbstractStructBase
{
    /**
     * The persoonsObjectAbo
     * Meta informations extracted from the WSDL
     * - documentation: Persoonsgegevens abonnee.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \WebApiV4\StructType\PersoonsObjectV4
     */
    public $persoonsObjectAbo;
    /**
     * The adresObjectAbo
     * Meta informations extracted from the WSDL
     * - documentation: Adresgegevens abonnee.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \WebApiV4\StructType\AdresObjectV4
     */
    public $adresObjectAbo;
    /**
     * The aboObject
     * Meta informations extracted from the WSDL
     * - documentation: Abonnementsgegevens.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \WebApiV4\StructType\AboObjectV4
     */
    public $aboObject;
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The geenControleLopendAbo
     * Meta informations extracted from the WSDL
     * - documentation: Controle actief abonnement niet uitvoeren voor deze aanvraag. Default false dus wel uitvoeren.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $geenControleLopendAbo;
    /**
     * The canCreate
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie of operatie in de testmodus wordt aangeroepen (er wordt dus geen relatie en abonnement aangemaakt) false (Default) = aanmaken, true = testmodus niet aanmaken.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $canCreate;
    /**
     * Constructor method for createAboAboNawRequest
     * @uses CreateAboAboNawRequest::setPersoonsObjectAbo()
     * @uses CreateAboAboNawRequest::setAdresObjectAbo()
     * @uses CreateAboAboNawRequest::setAboObject()
     * @uses CreateAboAboNawRequest::setRequestTag()
     * @uses CreateAboAboNawRequest::setGeenControleLopendAbo()
     * @uses CreateAboAboNawRequest::setCanCreate()
     * @param \WebApiV4\StructType\PersoonsObjectV4 $persoonsObjectAbo
     * @param \WebApiV4\StructType\AdresObjectV4 $adresObjectAbo
     * @param \WebApiV4\StructType\AboObjectV4 $aboObject
     * @param string $requestTag
     * @param bool $geenControleLopendAbo
     * @param bool $canCreate
     */
    public function __construct(\WebApiV4\StructType\PersoonsObjectV4 $persoonsObjectAbo = null, \WebApiV4\StructType\AdresObjectV4 $adresObjectAbo = null, \WebApiV4\StructType\AboObjectV4 $aboObject = null, $requestTag = null, $geenControleLopendAbo = null, $canCreate = null)
    {
        $this
            ->setPersoonsObjectAbo($persoonsObjectAbo)
            ->setAdresObjectAbo($adresObjectAbo)
            ->setAboObject($aboObject)
            ->setRequestTag($requestTag)
            ->setGeenControleLopendAbo($geenControleLopendAbo)
            ->setCanCreate($canCreate);
    }
    /**
     * Get persoonsObjectAbo value
     * @return \WebApiV4\StructType\PersoonsObjectV4
     */
    public function getPersoonsObjectAbo()
    {
        return $this->persoonsObjectAbo;
    }
    /**
     * Set persoonsObjectAbo value
     * @param \WebApiV4\StructType\PersoonsObjectV4 $persoonsObjectAbo
     * @return \WebApiV4\StructType\CreateAboAboNawRequest
     */
    public function setPersoonsObjectAbo(\WebApiV4\StructType\PersoonsObjectV4 $persoonsObjectAbo = null)
    {
        $this->persoonsObjectAbo = $persoonsObjectAbo;
        return $this;
    }
    /**
     * Get adresObjectAbo value
     * @return \WebApiV4\StructType\AdresObjectV4
     */
    public function getAdresObjectAbo()
    {
        return $this->adresObjectAbo;
    }
    /**
     * Set adresObjectAbo value
     * @param \WebApiV4\StructType\AdresObjectV4 $adresObjectAbo
     * @return \WebApiV4\StructType\CreateAboAboNawRequest
     */
    public function setAdresObjectAbo(\WebApiV4\StructType\AdresObjectV4 $adresObjectAbo = null)
    {
        $this->adresObjectAbo = $adresObjectAbo;
        return $this;
    }
    /**
     * Get aboObject value
     * @return \WebApiV4\StructType\AboObjectV4
     */
    public function getAboObject()
    {
        return $this->aboObject;
    }
    /**
     * Set aboObject value
     * @param \WebApiV4\StructType\AboObjectV4 $aboObject
     * @return \WebApiV4\StructType\CreateAboAboNawRequest
     */
    public function setAboObject(\WebApiV4\StructType\AboObjectV4 $aboObject = null)
    {
        $this->aboObject = $aboObject;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \WebApiV4\StructType\CreateAboAboNawRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get geenControleLopendAbo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getGeenControleLopendAbo()
    {
        return isset($this->geenControleLopendAbo) ? $this->geenControleLopendAbo : null;
    }
    /**
     * Set geenControleLopendAbo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $geenControleLopendAbo
     * @return \WebApiV4\StructType\CreateAboAboNawRequest
     */
    public function setGeenControleLopendAbo($geenControleLopendAbo = null)
    {
        // validation for constraint: boolean
        if (!is_null($geenControleLopendAbo) && !is_bool($geenControleLopendAbo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($geenControleLopendAbo, true), gettype($geenControleLopendAbo)), __LINE__);
        }
        if (is_null($geenControleLopendAbo) || (is_array($geenControleLopendAbo) && empty($geenControleLopendAbo))) {
            unset($this->geenControleLopendAbo);
        } else {
            $this->geenControleLopendAbo = $geenControleLopendAbo;
        }
        return $this;
    }
    /**
     * Get canCreate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanCreate()
    {
        return isset($this->canCreate) ? $this->canCreate : null;
    }
    /**
     * Set canCreate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canCreate
     * @return \WebApiV4\StructType\CreateAboAboNawRequest
     */
    public function setCanCreate($canCreate = null)
    {
        // validation for constraint: boolean
        if (!is_null($canCreate) && !is_bool($canCreate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canCreate, true), gettype($canCreate)), __LINE__);
        }
        if (is_null($canCreate) || (is_array($canCreate) && empty($canCreate))) {
            unset($this->canCreate);
        } else {
            $this->canCreate = $canCreate;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\CreateAboAboNawRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
