<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for addLicentiehouderResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: error239: Het abonnement is geen licentieabonnement. | error236: De opgegeven rol is niet gevonden bij de uitgave van het abonnement. | error19: Er is geen relatie opgegeven. | error12: Er is geen abonnement opgegeven. | error5: De
 * relatie is niet gevonden. | error1: Het abonnement is niet gevonden.
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class AddLicentiehouderResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The licentieNo
     * Meta informations extracted from the WSDL
     * - documentation: Nummer van de licentie.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $licentieNo;
    /**
     * Constructor method for addLicentiehouderResponse
     * @uses AddLicentiehouderResponse::setRequestTag()
     * @uses AddLicentiehouderResponse::setLicentieNo()
     * @param string $requestTag
     * @param int $licentieNo
     */
    public function __construct($requestTag = null, $licentieNo = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setLicentieNo($licentieNo);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \WebApiV4\StructType\AddLicentiehouderResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get licentieNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLicentieNo()
    {
        return isset($this->licentieNo) ? $this->licentieNo : null;
    }
    /**
     * Set licentieNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $licentieNo
     * @return \WebApiV4\StructType\AddLicentiehouderResponse
     */
    public function setLicentieNo($licentieNo = null)
    {
        // validation for constraint: int
        if (!is_null($licentieNo) && !(is_int($licentieNo) || ctype_digit($licentieNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($licentieNo, true), gettype($licentieNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($licentieNo) && mb_strlen(preg_replace('/(\D)/', '', $licentieNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($licentieNo, true), mb_strlen(preg_replace('/(\D)/', '', $licentieNo))), __LINE__);
        }
        if (is_null($licentieNo) || (is_array($licentieNo) && empty($licentieNo))) {
            unset($this->licentieNo);
        } else {
            $this->licentieNo = $licentieNo;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\AddLicentiehouderResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
