<?php

namespace WebApiV4\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Search ServiceType
 * @subpackage Services
 * @date 20190723
 * @package WebApiV4
 */
class Search extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \WebApiV4\StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\WebApiV4\StructType\Authentication $authentication, $nameSpace = 'http://zeno.socho.nl', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named searchAbonnement
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \WebApiV4\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Zoeken van abonnements informatie.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WebApiV4\StructType\SearchAbonnementRequest $request_parameters
     * @return \WebApiV4\StructType\SearchAbonnementResponse|bool
     */
    public function searchAbonnement(\WebApiV4\StructType\SearchAbonnementRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->searchAbonnement($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named searchAbonnementByCred
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \WebApiV4\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Geeft een lijst met abonnementen op die gelden voor de opgegeven userName en password combinatie.error11: Op basis van de opgegeven username en password is er meer dan 1 abonnement gevondenerror12: Op basis van de opgegeven username
     * en password is er meer dan 1 relatie gevondenerror14: Op basis van de opgegeven username en password is geen relatie of abonnement gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WebApiV4\StructType\SearchAbonnementByCredRequest $request_parameters
     * @return \WebApiV4\StructType\SearchAbonnementByCredResponse|bool
     */
    public function searchAbonnementByCred(\WebApiV4\StructType\SearchAbonnementByCredRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->searchAbonnementByCred($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named searchSmartcode
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \WebApiV4\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Geeft het aboneementnummer terug van het abonnement behorende bij de smartcode.error1: Op basis van de smartcode is geen abonnement gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WebApiV4\StructType\SearchSmartcodeRequest $request_parameters
     * @return \WebApiV4\StructType\SearchSmartcodeResponse|bool
     */
    public function searchSmartcode(\WebApiV4\StructType\SearchSmartcodeRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->searchSmartcode($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named searchRelNoByAboNo
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \WebApiV4\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Geeft het relatienummer van het opgegeven abonnementnummer terug
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WebApiV4\StructType\SearchRelNoByAboNoRequest $request_parameters
     * @return \WebApiV4\StructType\SearchRelNoByAboNoResponse|bool
     */
    public function searchRelNoByAboNo(\WebApiV4\StructType\SearchRelNoByAboNoRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->searchRelNoByAboNo($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named searchRelNoByEmail
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \WebApiV4\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Geeft een lijst met relatienummers terug die het opgegeven e-mail adres hebben.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WebApiV4\StructType\SearchRelNoByEmailRequest $request_parameters
     * @return \WebApiV4\StructType\SearchRelNoByEmailResponse|bool
     */
    public function searchRelNoByEmail(\WebApiV4\StructType\SearchRelNoByEmailRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->searchRelNoByEmail($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \WebApiV4\StructType\SearchAbonnementByCredResponse|\WebApiV4\StructType\SearchAbonnementResponse|\WebApiV4\StructType\SearchRelNoByAboNoResponse|\WebApiV4\StructType\SearchRelNoByEmailResponse|\WebApiV4\StructType\SearchSmartcodeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
