<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VerschInfoV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Verschijning.
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class VerschInfoV4 extends AbstractStructBase
{
    /**
     * The aboNo
     * Meta informations extracted from the WSDL
     * - documentation: Abonnementsnummer.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $aboNo;
    /**
     * The nabezorgTermijn
     * Meta informations extracted from the WSDL
     * - documentation: Aantal dagen terug dat nabezorgd kan worden.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $nabezorgTermijn;
    /**
     * The startBezorgingDatum
     * Meta informations extracted from the WSDL
     * - documentation: Datum start bezorging.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $startBezorgingDatum;
    /**
     * The startBezorgingTijd
     * Meta informations extracted from the WSDL
     * - documentation: Tijd start bezorging.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $startBezorgingTijd;
    /**
     * The bezorgdVanafDatum
     * Meta informations extracted from the WSDL
     * - documentation: Datum vanaf wanneer de verschijning in ieder geval bezorgd moet zijn.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $bezorgdVanafDatum;
    /**
     * The bezorgdVanafTijd
     * Meta informations extracted from the WSDL
     * - documentation: Tijd vanaf wanneer de verschijning in ieder geval bezorgd moet zijn.
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $bezorgdVanafTijd;
    /**
     * The nabezZelfDagMogTotDatum
     * Meta informations extracted from the WSDL
     * - documentation: Datum (van vandaag) met de datum tot wanneer het vandaag mogelijk is een nabezorging geleverd te krijgen. Daarna wordt de volgende bezorgdag nabezorgd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $nabezZelfDagMogTotDatum;
    /**
     * The nabezZelfDagMogTotTijd
     * Meta informations extracted from the WSDL
     * - documentation: Tijd tot wanneer het vandaag mogelijk is een nabezorging geleverd te krijgen. Daarna wordt de volgende bezorgdag nabezorgd.
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $nabezZelfDagMogTotTijd;
    /**
     * The nabezMogTotDatum
     * Meta informations extracted from the WSDL
     * - documentation: Datum (van vandaag) met uiterste tijdstip om nog nabezorging te kunnen krijgen.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $nabezMogTotDatum;
    /**
     * The nabezMogTotTijd
     * Meta informations extracted from the WSDL
     * - documentation: Tijd met uiterste tijdstip om nog nabezorging te kunnen krijgen.
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $nabezMogTotTijd;
    /**
     * Constructor method for VerschInfoV4
     * @uses VerschInfoV4::setAboNo()
     * @uses VerschInfoV4::setNabezorgTermijn()
     * @uses VerschInfoV4::setStartBezorgingDatum()
     * @uses VerschInfoV4::setStartBezorgingTijd()
     * @uses VerschInfoV4::setBezorgdVanafDatum()
     * @uses VerschInfoV4::setBezorgdVanafTijd()
     * @uses VerschInfoV4::setNabezZelfDagMogTotDatum()
     * @uses VerschInfoV4::setNabezZelfDagMogTotTijd()
     * @uses VerschInfoV4::setNabezMogTotDatum()
     * @uses VerschInfoV4::setNabezMogTotTijd()
     * @param int $aboNo
     * @param int $nabezorgTermijn
     * @param string $startBezorgingDatum
     * @param string $startBezorgingTijd
     * @param string $bezorgdVanafDatum
     * @param string $bezorgdVanafTijd
     * @param string $nabezZelfDagMogTotDatum
     * @param string $nabezZelfDagMogTotTijd
     * @param string $nabezMogTotDatum
     * @param string $nabezMogTotTijd
     */
    public function __construct($aboNo = null, $nabezorgTermijn = null, $startBezorgingDatum = null, $startBezorgingTijd = null, $bezorgdVanafDatum = null, $bezorgdVanafTijd = null, $nabezZelfDagMogTotDatum = null, $nabezZelfDagMogTotTijd = null, $nabezMogTotDatum = null, $nabezMogTotTijd = null)
    {
        $this
            ->setAboNo($aboNo)
            ->setNabezorgTermijn($nabezorgTermijn)
            ->setStartBezorgingDatum($startBezorgingDatum)
            ->setStartBezorgingTijd($startBezorgingTijd)
            ->setBezorgdVanafDatum($bezorgdVanafDatum)
            ->setBezorgdVanafTijd($bezorgdVanafTijd)
            ->setNabezZelfDagMogTotDatum($nabezZelfDagMogTotDatum)
            ->setNabezZelfDagMogTotTijd($nabezZelfDagMogTotTijd)
            ->setNabezMogTotDatum($nabezMogTotDatum)
            ->setNabezMogTotTijd($nabezMogTotTijd);
    }
    /**
     * Get aboNo value
     * @return int
     */
    public function getAboNo()
    {
        return $this->aboNo;
    }
    /**
     * Set aboNo value
     * @param int $aboNo
     * @return \WebApiV4\StructType\VerschInfoV4
     */
    public function setAboNo($aboNo = null)
    {
        // validation for constraint: int
        if (!is_null($aboNo) && !(is_int($aboNo) || ctype_digit($aboNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aboNo, true), gettype($aboNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($aboNo) && mb_strlen(preg_replace('/(\D)/', '', $aboNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($aboNo, true), mb_strlen(preg_replace('/(\D)/', '', $aboNo))), __LINE__);
        }
        $this->aboNo = $aboNo;
        return $this;
    }
    /**
     * Get nabezorgTermijn value
     * @return int
     */
    public function getNabezorgTermijn()
    {
        return $this->nabezorgTermijn;
    }
    /**
     * Set nabezorgTermijn value
     * @param int $nabezorgTermijn
     * @return \WebApiV4\StructType\VerschInfoV4
     */
    public function setNabezorgTermijn($nabezorgTermijn = null)
    {
        // validation for constraint: int
        if (!is_null($nabezorgTermijn) && !(is_int($nabezorgTermijn) || ctype_digit($nabezorgTermijn))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nabezorgTermijn, true), gettype($nabezorgTermijn)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($nabezorgTermijn) && mb_strlen(preg_replace('/(\D)/', '', $nabezorgTermijn)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($nabezorgTermijn, true), mb_strlen(preg_replace('/(\D)/', '', $nabezorgTermijn))), __LINE__);
        }
        $this->nabezorgTermijn = $nabezorgTermijn;
        return $this;
    }
    /**
     * Get startBezorgingDatum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartBezorgingDatum()
    {
        return isset($this->startBezorgingDatum) ? $this->startBezorgingDatum : null;
    }
    /**
     * Set startBezorgingDatum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startBezorgingDatum
     * @return \WebApiV4\StructType\VerschInfoV4
     */
    public function setStartBezorgingDatum($startBezorgingDatum = null)
    {
        // validation for constraint: string
        if (!is_null($startBezorgingDatum) && !is_string($startBezorgingDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startBezorgingDatum, true), gettype($startBezorgingDatum)), __LINE__);
        }
        if (is_null($startBezorgingDatum) || (is_array($startBezorgingDatum) && empty($startBezorgingDatum))) {
            unset($this->startBezorgingDatum);
        } else {
            $this->startBezorgingDatum = $startBezorgingDatum;
        }
        return $this;
    }
    /**
     * Get startBezorgingTijd value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartBezorgingTijd()
    {
        return isset($this->startBezorgingTijd) ? $this->startBezorgingTijd : null;
    }
    /**
     * Set startBezorgingTijd value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startBezorgingTijd
     * @return \WebApiV4\StructType\VerschInfoV4
     */
    public function setStartBezorgingTijd($startBezorgingTijd = null)
    {
        // validation for constraint: string
        if (!is_null($startBezorgingTijd) && !is_string($startBezorgingTijd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startBezorgingTijd, true), gettype($startBezorgingTijd)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($startBezorgingTijd) && mb_strlen($startBezorgingTijd) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($startBezorgingTijd)), __LINE__);
        }
        if (is_null($startBezorgingTijd) || (is_array($startBezorgingTijd) && empty($startBezorgingTijd))) {
            unset($this->startBezorgingTijd);
        } else {
            $this->startBezorgingTijd = $startBezorgingTijd;
        }
        return $this;
    }
    /**
     * Get bezorgdVanafDatum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBezorgdVanafDatum()
    {
        return isset($this->bezorgdVanafDatum) ? $this->bezorgdVanafDatum : null;
    }
    /**
     * Set bezorgdVanafDatum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bezorgdVanafDatum
     * @return \WebApiV4\StructType\VerschInfoV4
     */
    public function setBezorgdVanafDatum($bezorgdVanafDatum = null)
    {
        // validation for constraint: string
        if (!is_null($bezorgdVanafDatum) && !is_string($bezorgdVanafDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bezorgdVanafDatum, true), gettype($bezorgdVanafDatum)), __LINE__);
        }
        if (is_null($bezorgdVanafDatum) || (is_array($bezorgdVanafDatum) && empty($bezorgdVanafDatum))) {
            unset($this->bezorgdVanafDatum);
        } else {
            $this->bezorgdVanafDatum = $bezorgdVanafDatum;
        }
        return $this;
    }
    /**
     * Get bezorgdVanafTijd value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBezorgdVanafTijd()
    {
        return isset($this->bezorgdVanafTijd) ? $this->bezorgdVanafTijd : null;
    }
    /**
     * Set bezorgdVanafTijd value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bezorgdVanafTijd
     * @return \WebApiV4\StructType\VerschInfoV4
     */
    public function setBezorgdVanafTijd($bezorgdVanafTijd = null)
    {
        // validation for constraint: string
        if (!is_null($bezorgdVanafTijd) && !is_string($bezorgdVanafTijd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bezorgdVanafTijd, true), gettype($bezorgdVanafTijd)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($bezorgdVanafTijd) && mb_strlen($bezorgdVanafTijd) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($bezorgdVanafTijd)), __LINE__);
        }
        if (is_null($bezorgdVanafTijd) || (is_array($bezorgdVanafTijd) && empty($bezorgdVanafTijd))) {
            unset($this->bezorgdVanafTijd);
        } else {
            $this->bezorgdVanafTijd = $bezorgdVanafTijd;
        }
        return $this;
    }
    /**
     * Get nabezZelfDagMogTotDatum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNabezZelfDagMogTotDatum()
    {
        return isset($this->nabezZelfDagMogTotDatum) ? $this->nabezZelfDagMogTotDatum : null;
    }
    /**
     * Set nabezZelfDagMogTotDatum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nabezZelfDagMogTotDatum
     * @return \WebApiV4\StructType\VerschInfoV4
     */
    public function setNabezZelfDagMogTotDatum($nabezZelfDagMogTotDatum = null)
    {
        // validation for constraint: string
        if (!is_null($nabezZelfDagMogTotDatum) && !is_string($nabezZelfDagMogTotDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nabezZelfDagMogTotDatum, true), gettype($nabezZelfDagMogTotDatum)), __LINE__);
        }
        if (is_null($nabezZelfDagMogTotDatum) || (is_array($nabezZelfDagMogTotDatum) && empty($nabezZelfDagMogTotDatum))) {
            unset($this->nabezZelfDagMogTotDatum);
        } else {
            $this->nabezZelfDagMogTotDatum = $nabezZelfDagMogTotDatum;
        }
        return $this;
    }
    /**
     * Get nabezZelfDagMogTotTijd value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNabezZelfDagMogTotTijd()
    {
        return isset($this->nabezZelfDagMogTotTijd) ? $this->nabezZelfDagMogTotTijd : null;
    }
    /**
     * Set nabezZelfDagMogTotTijd value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nabezZelfDagMogTotTijd
     * @return \WebApiV4\StructType\VerschInfoV4
     */
    public function setNabezZelfDagMogTotTijd($nabezZelfDagMogTotTijd = null)
    {
        // validation for constraint: string
        if (!is_null($nabezZelfDagMogTotTijd) && !is_string($nabezZelfDagMogTotTijd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nabezZelfDagMogTotTijd, true), gettype($nabezZelfDagMogTotTijd)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($nabezZelfDagMogTotTijd) && mb_strlen($nabezZelfDagMogTotTijd) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($nabezZelfDagMogTotTijd)), __LINE__);
        }
        if (is_null($nabezZelfDagMogTotTijd) || (is_array($nabezZelfDagMogTotTijd) && empty($nabezZelfDagMogTotTijd))) {
            unset($this->nabezZelfDagMogTotTijd);
        } else {
            $this->nabezZelfDagMogTotTijd = $nabezZelfDagMogTotTijd;
        }
        return $this;
    }
    /**
     * Get nabezMogTotDatum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNabezMogTotDatum()
    {
        return isset($this->nabezMogTotDatum) ? $this->nabezMogTotDatum : null;
    }
    /**
     * Set nabezMogTotDatum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nabezMogTotDatum
     * @return \WebApiV4\StructType\VerschInfoV4
     */
    public function setNabezMogTotDatum($nabezMogTotDatum = null)
    {
        // validation for constraint: string
        if (!is_null($nabezMogTotDatum) && !is_string($nabezMogTotDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nabezMogTotDatum, true), gettype($nabezMogTotDatum)), __LINE__);
        }
        if (is_null($nabezMogTotDatum) || (is_array($nabezMogTotDatum) && empty($nabezMogTotDatum))) {
            unset($this->nabezMogTotDatum);
        } else {
            $this->nabezMogTotDatum = $nabezMogTotDatum;
        }
        return $this;
    }
    /**
     * Get nabezMogTotTijd value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNabezMogTotTijd()
    {
        return isset($this->nabezMogTotTijd) ? $this->nabezMogTotTijd : null;
    }
    /**
     * Set nabezMogTotTijd value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nabezMogTotTijd
     * @return \WebApiV4\StructType\VerschInfoV4
     */
    public function setNabezMogTotTijd($nabezMogTotTijd = null)
    {
        // validation for constraint: string
        if (!is_null($nabezMogTotTijd) && !is_string($nabezMogTotTijd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nabezMogTotTijd, true), gettype($nabezMogTotTijd)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($nabezMogTotTijd) && mb_strlen($nabezMogTotTijd) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($nabezMogTotTijd)), __LINE__);
        }
        if (is_null($nabezMogTotTijd) || (is_array($nabezMogTotTijd) && empty($nabezMogTotTijd))) {
            unset($this->nabezMogTotTijd);
        } else {
            $this->nabezMogTotTijd = $nabezMogTotTijd;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\VerschInfoV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
