<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VerschInfoTabV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst met verschijningen.
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class VerschInfoTabV4 extends AbstractStructBase
{
    /**
     * The verschInfo
     * Meta informations extracted from the WSDL
     * - documentation: Lijst met verschijningen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \WebApiV4\StructType\VerschInfoV4[]
     */
    public $verschInfo;
    /**
     * Constructor method for VerschInfoTabV4
     * @uses VerschInfoTabV4::setVerschInfo()
     * @param \WebApiV4\StructType\VerschInfoV4[] $verschInfo
     */
    public function __construct(array $verschInfo = array())
    {
        $this
            ->setVerschInfo($verschInfo);
    }
    /**
     * Get verschInfo value
     * @return \WebApiV4\StructType\VerschInfoV4[]|null
     */
    public function getVerschInfo()
    {
        return $this->verschInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setVerschInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVerschInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVerschInfoForArrayConstraintsFromSetVerschInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $verschInfoTabV4VerschInfoItem) {
            // validation for constraint: itemType
            if (!$verschInfoTabV4VerschInfoItem instanceof \WebApiV4\StructType\VerschInfoV4) {
                $invalidValues[] = is_object($verschInfoTabV4VerschInfoItem) ? get_class($verschInfoTabV4VerschInfoItem) : sprintf('%s(%s)', gettype($verschInfoTabV4VerschInfoItem), var_export($verschInfoTabV4VerschInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The verschInfo property can only contain items of type \WebApiV4\StructType\VerschInfoV4, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set verschInfo value
     * @throws \InvalidArgumentException
     * @param \WebApiV4\StructType\VerschInfoV4[] $verschInfo
     * @return \WebApiV4\StructType\VerschInfoTabV4
     */
    public function setVerschInfo(array $verschInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($verschInfoArrayErrorMessage = self::validateVerschInfoForArrayConstraintsFromSetVerschInfo($verschInfo))) {
            throw new \InvalidArgumentException($verschInfoArrayErrorMessage, __LINE__);
        }
        $this->verschInfo = $verschInfo;
        return $this;
    }
    /**
     * Add item to verschInfo value
     * @throws \InvalidArgumentException
     * @param \WebApiV4\StructType\VerschInfoV4 $item
     * @return \WebApiV4\StructType\VerschInfoTabV4
     */
    public function addToVerschInfo(\WebApiV4\StructType\VerschInfoV4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \WebApiV4\StructType\VerschInfoV4) {
            throw new \InvalidArgumentException(sprintf('The verschInfo property can only contain items of type \WebApiV4\StructType\VerschInfoV4, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->verschInfo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\VerschInfoTabV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
