<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VerbandInfoV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst met verbanden.
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class VerbandInfoV4 extends AbstractStructBase
{
    /**
     * The verband
     * Meta informations extracted from the WSDL
     * - documentation: Lijst met verbanden.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \WebApiV4\StructType\VerbandV4[]
     */
    public $verband;
    /**
     * Constructor method for VerbandInfoV4
     * @uses VerbandInfoV4::setVerband()
     * @param \WebApiV4\StructType\VerbandV4[] $verband
     */
    public function __construct(array $verband = array())
    {
        $this
            ->setVerband($verband);
    }
    /**
     * Get verband value
     * @return \WebApiV4\StructType\VerbandV4[]|null
     */
    public function getVerband()
    {
        return $this->verband;
    }
    /**
     * This method is responsible for validating the values passed to the setVerband method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVerband method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVerbandForArrayConstraintsFromSetVerband(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $verbandInfoV4VerbandItem) {
            // validation for constraint: itemType
            if (!$verbandInfoV4VerbandItem instanceof \WebApiV4\StructType\VerbandV4) {
                $invalidValues[] = is_object($verbandInfoV4VerbandItem) ? get_class($verbandInfoV4VerbandItem) : sprintf('%s(%s)', gettype($verbandInfoV4VerbandItem), var_export($verbandInfoV4VerbandItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The verband property can only contain items of type \WebApiV4\StructType\VerbandV4, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set verband value
     * @throws \InvalidArgumentException
     * @param \WebApiV4\StructType\VerbandV4[] $verband
     * @return \WebApiV4\StructType\VerbandInfoV4
     */
    public function setVerband(array $verband = array())
    {
        // validation for constraint: array
        if ('' !== ($verbandArrayErrorMessage = self::validateVerbandForArrayConstraintsFromSetVerband($verband))) {
            throw new \InvalidArgumentException($verbandArrayErrorMessage, __LINE__);
        }
        $this->verband = $verband;
        return $this;
    }
    /**
     * Add item to verband value
     * @throws \InvalidArgumentException
     * @param \WebApiV4\StructType\VerbandV4 $item
     * @return \WebApiV4\StructType\VerbandInfoV4
     */
    public function addToVerband(\WebApiV4\StructType\VerbandV4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \WebApiV4\StructType\VerbandV4) {
            throw new \InvalidArgumentException(sprintf('The verband property can only contain items of type \WebApiV4\StructType\VerbandV4, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->verband[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\VerbandInfoV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
