<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UitgaveInfoV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst met uitgaven.
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class UitgaveInfoV4 extends AbstractStructBase
{
    /**
     * The uitgave
     * Meta informations extracted from the WSDL
     * - documentation: Lijst met uitgaven.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \WebApiV4\StructType\UitgaveV4[]
     */
    public $uitgave;
    /**
     * Constructor method for UitgaveInfoV4
     * @uses UitgaveInfoV4::setUitgave()
     * @param \WebApiV4\StructType\UitgaveV4[] $uitgave
     */
    public function __construct(array $uitgave = array())
    {
        $this
            ->setUitgave($uitgave);
    }
    /**
     * Get uitgave value
     * @return \WebApiV4\StructType\UitgaveV4[]|null
     */
    public function getUitgave()
    {
        return $this->uitgave;
    }
    /**
     * This method is responsible for validating the values passed to the setUitgave method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUitgave method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUitgaveForArrayConstraintsFromSetUitgave(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $uitgaveInfoV4UitgaveItem) {
            // validation for constraint: itemType
            if (!$uitgaveInfoV4UitgaveItem instanceof \WebApiV4\StructType\UitgaveV4) {
                $invalidValues[] = is_object($uitgaveInfoV4UitgaveItem) ? get_class($uitgaveInfoV4UitgaveItem) : sprintf('%s(%s)', gettype($uitgaveInfoV4UitgaveItem), var_export($uitgaveInfoV4UitgaveItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The uitgave property can only contain items of type \WebApiV4\StructType\UitgaveV4, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set uitgave value
     * @throws \InvalidArgumentException
     * @param \WebApiV4\StructType\UitgaveV4[] $uitgave
     * @return \WebApiV4\StructType\UitgaveInfoV4
     */
    public function setUitgave(array $uitgave = array())
    {
        // validation for constraint: array
        if ('' !== ($uitgaveArrayErrorMessage = self::validateUitgaveForArrayConstraintsFromSetUitgave($uitgave))) {
            throw new \InvalidArgumentException($uitgaveArrayErrorMessage, __LINE__);
        }
        $this->uitgave = $uitgave;
        return $this;
    }
    /**
     * Add item to uitgave value
     * @throws \InvalidArgumentException
     * @param \WebApiV4\StructType\UitgaveV4 $item
     * @return \WebApiV4\StructType\UitgaveInfoV4
     */
    public function addToUitgave(\WebApiV4\StructType\UitgaveV4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \WebApiV4\StructType\UitgaveV4) {
            throw new \InvalidArgumentException(sprintf('The uitgave property can only contain items of type \WebApiV4\StructType\UitgaveV4, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->uitgave[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\UitgaveInfoV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
