<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for switchAbonnementResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: error265: Een betaalwijze anders dan factuur per mail is niet toegestaan voor dit abonnement | error264: Bij betaalwijze creditcard zijn gegevens van de creditcard verplicht | error263: De opgegeven vrije code 4 is niet bekend |
 * error262: De opgegeven vrije code 2 is niet bekend | error261: De opgegeven vrije code 1 is niet bekend | error260: Een propositiecode dient in combinatie met een actiecode opgegeven te worden | error259: De opgegeven vrije code 3 is niet bekend |
 * error258: Op basis van de opgegeven abosoort/pakket/propositiecode en actiecode zijn meerdere proposities gevonden | error257: De propositie is niet actief | error256: De proposie is niet gevonden | error219: De opgegeven BIC code hoort niet bij het
 * opgegeven IBAN nummer | error218: Het IBAN nummer dient samen met de BIC code opgegeven te worden | error217: Bij automatische incasso of eenmalige incasso is een IBAN nummer verplicht | error216: De BIC code is ongeldig | error215: Het IBAN nummer
 * is ongeldig | error181: De stopreden is niet gevonden | error131: Een betaalwijze anders dan incasso is niet toegestaan voor dit abonnement | error128: Het pakket is niet gekoppeld aan de actie | error127: De abonnementsoort is niet gekoppeld aan de
 * actie | error98: De premium voor de debiteur is niet gekoppeld aan de propositie | error97: De premium voor de abonnee is niet gekoppeld aan de propositie | error96: De einddatum van de actie is verstreken | error95: De ingangsdatum van de actie is
 * nog niet ingegaan | error92: De abonnementsoort is niet bekend | error91: De premium voor de debiteur is niet actief | error89: Het opgegeven pakket is niet actief | error88: Het opgegeven pakket is niet bekend | error58: De premium voor de abonnee
 * is niet actief | error57: De actie is niet actief | error56: De abonnementsoort is niet actief | error36: De ingangsdatum van de actie is nog niet ingegaan | error34: De actie is niet gevonden | error33: Geef of een abonnementsoort- of een pakketcode
 * op | error23: De premium voor de abonnee is niet gevonden | error12: Er is geen abonnement opgegeven | error1: Het abonnement is niet gevonden
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class SwitchAbonnementResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The aboIngangsDatum
     * Meta informations extracted from the WSDL
     * - documentation: Ingangsdatum van het nieuwe abonnement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboIngangsDatum;
    /**
     * The aboNoResult
     * Meta informations extracted from the WSDL
     * - documentation: Abonnementsnummer van het nieuwe abonnemet.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $aboNoResult;
    /**
     * The aboRelNo
     * Meta informations extracted from the WSDL
     * - documentation: Relatienummer van de abonnee van het nieuwe abonnement.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $aboRelNo;
    /**
     * The aboBedragNieuw
     * Meta informations extracted from the WSDL
     * - documentation: Bedrag te betalen voor het nieuwe abonnement.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $aboBedragNieuw;
    /**
     * The aboBedragOud
     * Meta informations extracted from the WSDL
     * - documentation: Bedrag terug te ontvangen voor het oude abonnement.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $aboBedragOud;
    /**
     * The aboBedragFactuur
     * Meta informations extracted from the WSDL
     * - documentation: Totaal te betalen bedrag.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $aboBedragFactuur;
    /**
     * The aboBedragAdmKosten
     * Meta informations extracted from the WSDL
     * - documentation: Bedrag te betalen administratie kosten (future support).
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $aboBedragAdmKosten;
    /**
     * The aboFactuurNummer
     * Meta informations extracted from the WSDL
     * - documentation: Nummer van de aangemaakte factuur.
     * - base: xsd:string
     * - maxLength: 17
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboFactuurNummer;
    /**
     * The aboFactuurOnderdrukkenRslt
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie of de factuur wordt onderdrukt. Als in het request is aangegeven dat de factuur onderdrukt moet worden, maar er is een factuur zonder automatische incasso aangemaakt, dan komt hier alsnog een indicatie false, dus factuur
     * wordt verstuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $aboFactuurOnderdrukkenRslt;
    /**
     * The machtigingsKenmerk
     * Meta informations extracted from the WSDL
     * - documentation: Door Zeno aangemaakt machtigingskenmerk in geval van betaalwijze SEPA incasso.
     * - base: xsd:string
     * - maxLength: 35
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $machtigingsKenmerk;
    /**
     * Constructor method for switchAbonnementResponse
     * @uses SwitchAbonnementResponse::setRequestTag()
     * @uses SwitchAbonnementResponse::setAboIngangsDatum()
     * @uses SwitchAbonnementResponse::setAboNoResult()
     * @uses SwitchAbonnementResponse::setAboRelNo()
     * @uses SwitchAbonnementResponse::setAboBedragNieuw()
     * @uses SwitchAbonnementResponse::setAboBedragOud()
     * @uses SwitchAbonnementResponse::setAboBedragFactuur()
     * @uses SwitchAbonnementResponse::setAboBedragAdmKosten()
     * @uses SwitchAbonnementResponse::setAboFactuurNummer()
     * @uses SwitchAbonnementResponse::setAboFactuurOnderdrukkenRslt()
     * @uses SwitchAbonnementResponse::setMachtigingsKenmerk()
     * @param string $requestTag
     * @param string $aboIngangsDatum
     * @param int $aboNoResult
     * @param int $aboRelNo
     * @param float $aboBedragNieuw
     * @param float $aboBedragOud
     * @param float $aboBedragFactuur
     * @param float $aboBedragAdmKosten
     * @param string $aboFactuurNummer
     * @param bool $aboFactuurOnderdrukkenRslt
     * @param string $machtigingsKenmerk
     */
    public function __construct($requestTag = null, $aboIngangsDatum = null, $aboNoResult = null, $aboRelNo = null, $aboBedragNieuw = null, $aboBedragOud = null, $aboBedragFactuur = null, $aboBedragAdmKosten = null, $aboFactuurNummer = null, $aboFactuurOnderdrukkenRslt = null, $machtigingsKenmerk = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setAboIngangsDatum($aboIngangsDatum)
            ->setAboNoResult($aboNoResult)
            ->setAboRelNo($aboRelNo)
            ->setAboBedragNieuw($aboBedragNieuw)
            ->setAboBedragOud($aboBedragOud)
            ->setAboBedragFactuur($aboBedragFactuur)
            ->setAboBedragAdmKosten($aboBedragAdmKosten)
            ->setAboFactuurNummer($aboFactuurNummer)
            ->setAboFactuurOnderdrukkenRslt($aboFactuurOnderdrukkenRslt)
            ->setMachtigingsKenmerk($machtigingsKenmerk);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \WebApiV4\StructType\SwitchAbonnementResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get aboIngangsDatum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboIngangsDatum()
    {
        return isset($this->aboIngangsDatum) ? $this->aboIngangsDatum : null;
    }
    /**
     * Set aboIngangsDatum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboIngangsDatum
     * @return \WebApiV4\StructType\SwitchAbonnementResponse
     */
    public function setAboIngangsDatum($aboIngangsDatum = null)
    {
        // validation for constraint: string
        if (!is_null($aboIngangsDatum) && !is_string($aboIngangsDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aboIngangsDatum, true), gettype($aboIngangsDatum)), __LINE__);
        }
        if (is_null($aboIngangsDatum) || (is_array($aboIngangsDatum) && empty($aboIngangsDatum))) {
            unset($this->aboIngangsDatum);
        } else {
            $this->aboIngangsDatum = $aboIngangsDatum;
        }
        return $this;
    }
    /**
     * Get aboNoResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAboNoResult()
    {
        return isset($this->aboNoResult) ? $this->aboNoResult : null;
    }
    /**
     * Set aboNoResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aboNoResult
     * @return \WebApiV4\StructType\SwitchAbonnementResponse
     */
    public function setAboNoResult($aboNoResult = null)
    {
        // validation for constraint: int
        if (!is_null($aboNoResult) && !(is_int($aboNoResult) || ctype_digit($aboNoResult))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aboNoResult, true), gettype($aboNoResult)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($aboNoResult) && mb_strlen(preg_replace('/(\D)/', '', $aboNoResult)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($aboNoResult, true), mb_strlen(preg_replace('/(\D)/', '', $aboNoResult))), __LINE__);
        }
        if (is_null($aboNoResult) || (is_array($aboNoResult) && empty($aboNoResult))) {
            unset($this->aboNoResult);
        } else {
            $this->aboNoResult = $aboNoResult;
        }
        return $this;
    }
    /**
     * Get aboRelNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAboRelNo()
    {
        return isset($this->aboRelNo) ? $this->aboRelNo : null;
    }
    /**
     * Set aboRelNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aboRelNo
     * @return \WebApiV4\StructType\SwitchAbonnementResponse
     */
    public function setAboRelNo($aboRelNo = null)
    {
        // validation for constraint: int
        if (!is_null($aboRelNo) && !(is_int($aboRelNo) || ctype_digit($aboRelNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aboRelNo, true), gettype($aboRelNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($aboRelNo) && mb_strlen(preg_replace('/(\D)/', '', $aboRelNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($aboRelNo, true), mb_strlen(preg_replace('/(\D)/', '', $aboRelNo))), __LINE__);
        }
        if (is_null($aboRelNo) || (is_array($aboRelNo) && empty($aboRelNo))) {
            unset($this->aboRelNo);
        } else {
            $this->aboRelNo = $aboRelNo;
        }
        return $this;
    }
    /**
     * Get aboBedragNieuw value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAboBedragNieuw()
    {
        return isset($this->aboBedragNieuw) ? $this->aboBedragNieuw : null;
    }
    /**
     * Set aboBedragNieuw value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $aboBedragNieuw
     * @return \WebApiV4\StructType\SwitchAbonnementResponse
     */
    public function setAboBedragNieuw($aboBedragNieuw = null)
    {
        // validation for constraint: float
        if (!is_null($aboBedragNieuw) && !(is_float($aboBedragNieuw) || is_numeric($aboBedragNieuw))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aboBedragNieuw, true), gettype($aboBedragNieuw)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($aboBedragNieuw) && mb_strlen(preg_replace('/(\D)/', '', $aboBedragNieuw)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($aboBedragNieuw, true), mb_strlen(preg_replace('/(\D)/', '', $aboBedragNieuw))), __LINE__);
        }
        if (is_null($aboBedragNieuw) || (is_array($aboBedragNieuw) && empty($aboBedragNieuw))) {
            unset($this->aboBedragNieuw);
        } else {
            $this->aboBedragNieuw = $aboBedragNieuw;
        }
        return $this;
    }
    /**
     * Get aboBedragOud value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAboBedragOud()
    {
        return isset($this->aboBedragOud) ? $this->aboBedragOud : null;
    }
    /**
     * Set aboBedragOud value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $aboBedragOud
     * @return \WebApiV4\StructType\SwitchAbonnementResponse
     */
    public function setAboBedragOud($aboBedragOud = null)
    {
        // validation for constraint: float
        if (!is_null($aboBedragOud) && !(is_float($aboBedragOud) || is_numeric($aboBedragOud))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aboBedragOud, true), gettype($aboBedragOud)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($aboBedragOud) && mb_strlen(preg_replace('/(\D)/', '', $aboBedragOud)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($aboBedragOud, true), mb_strlen(preg_replace('/(\D)/', '', $aboBedragOud))), __LINE__);
        }
        if (is_null($aboBedragOud) || (is_array($aboBedragOud) && empty($aboBedragOud))) {
            unset($this->aboBedragOud);
        } else {
            $this->aboBedragOud = $aboBedragOud;
        }
        return $this;
    }
    /**
     * Get aboBedragFactuur value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAboBedragFactuur()
    {
        return isset($this->aboBedragFactuur) ? $this->aboBedragFactuur : null;
    }
    /**
     * Set aboBedragFactuur value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $aboBedragFactuur
     * @return \WebApiV4\StructType\SwitchAbonnementResponse
     */
    public function setAboBedragFactuur($aboBedragFactuur = null)
    {
        // validation for constraint: float
        if (!is_null($aboBedragFactuur) && !(is_float($aboBedragFactuur) || is_numeric($aboBedragFactuur))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aboBedragFactuur, true), gettype($aboBedragFactuur)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($aboBedragFactuur) && mb_strlen(preg_replace('/(\D)/', '', $aboBedragFactuur)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($aboBedragFactuur, true), mb_strlen(preg_replace('/(\D)/', '', $aboBedragFactuur))), __LINE__);
        }
        if (is_null($aboBedragFactuur) || (is_array($aboBedragFactuur) && empty($aboBedragFactuur))) {
            unset($this->aboBedragFactuur);
        } else {
            $this->aboBedragFactuur = $aboBedragFactuur;
        }
        return $this;
    }
    /**
     * Get aboBedragAdmKosten value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAboBedragAdmKosten()
    {
        return isset($this->aboBedragAdmKosten) ? $this->aboBedragAdmKosten : null;
    }
    /**
     * Set aboBedragAdmKosten value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $aboBedragAdmKosten
     * @return \WebApiV4\StructType\SwitchAbonnementResponse
     */
    public function setAboBedragAdmKosten($aboBedragAdmKosten = null)
    {
        // validation for constraint: float
        if (!is_null($aboBedragAdmKosten) && !(is_float($aboBedragAdmKosten) || is_numeric($aboBedragAdmKosten))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aboBedragAdmKosten, true), gettype($aboBedragAdmKosten)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($aboBedragAdmKosten) && mb_strlen(preg_replace('/(\D)/', '', $aboBedragAdmKosten)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($aboBedragAdmKosten, true), mb_strlen(preg_replace('/(\D)/', '', $aboBedragAdmKosten))), __LINE__);
        }
        if (is_null($aboBedragAdmKosten) || (is_array($aboBedragAdmKosten) && empty($aboBedragAdmKosten))) {
            unset($this->aboBedragAdmKosten);
        } else {
            $this->aboBedragAdmKosten = $aboBedragAdmKosten;
        }
        return $this;
    }
    /**
     * Get aboFactuurNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboFactuurNummer()
    {
        return isset($this->aboFactuurNummer) ? $this->aboFactuurNummer : null;
    }
    /**
     * Set aboFactuurNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboFactuurNummer
     * @return \WebApiV4\StructType\SwitchAbonnementResponse
     */
    public function setAboFactuurNummer($aboFactuurNummer = null)
    {
        // validation for constraint: string
        if (!is_null($aboFactuurNummer) && !is_string($aboFactuurNummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aboFactuurNummer, true), gettype($aboFactuurNummer)), __LINE__);
        }
        // validation for constraint: maxLength(17)
        if (!is_null($aboFactuurNummer) && mb_strlen($aboFactuurNummer) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 17', mb_strlen($aboFactuurNummer)), __LINE__);
        }
        if (is_null($aboFactuurNummer) || (is_array($aboFactuurNummer) && empty($aboFactuurNummer))) {
            unset($this->aboFactuurNummer);
        } else {
            $this->aboFactuurNummer = $aboFactuurNummer;
        }
        return $this;
    }
    /**
     * Get aboFactuurOnderdrukkenRslt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAboFactuurOnderdrukkenRslt()
    {
        return isset($this->aboFactuurOnderdrukkenRslt) ? $this->aboFactuurOnderdrukkenRslt : null;
    }
    /**
     * Set aboFactuurOnderdrukkenRslt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $aboFactuurOnderdrukkenRslt
     * @return \WebApiV4\StructType\SwitchAbonnementResponse
     */
    public function setAboFactuurOnderdrukkenRslt($aboFactuurOnderdrukkenRslt = null)
    {
        // validation for constraint: boolean
        if (!is_null($aboFactuurOnderdrukkenRslt) && !is_bool($aboFactuurOnderdrukkenRslt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aboFactuurOnderdrukkenRslt, true), gettype($aboFactuurOnderdrukkenRslt)), __LINE__);
        }
        if (is_null($aboFactuurOnderdrukkenRslt) || (is_array($aboFactuurOnderdrukkenRslt) && empty($aboFactuurOnderdrukkenRslt))) {
            unset($this->aboFactuurOnderdrukkenRslt);
        } else {
            $this->aboFactuurOnderdrukkenRslt = $aboFactuurOnderdrukkenRslt;
        }
        return $this;
    }
    /**
     * Get machtigingsKenmerk value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMachtigingsKenmerk()
    {
        return isset($this->machtigingsKenmerk) ? $this->machtigingsKenmerk : null;
    }
    /**
     * Set machtigingsKenmerk value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $machtigingsKenmerk
     * @return \WebApiV4\StructType\SwitchAbonnementResponse
     */
    public function setMachtigingsKenmerk($machtigingsKenmerk = null)
    {
        // validation for constraint: string
        if (!is_null($machtigingsKenmerk) && !is_string($machtigingsKenmerk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($machtigingsKenmerk, true), gettype($machtigingsKenmerk)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($machtigingsKenmerk) && mb_strlen($machtigingsKenmerk) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($machtigingsKenmerk)), __LINE__);
        }
        if (is_null($machtigingsKenmerk) || (is_array($machtigingsKenmerk) && empty($machtigingsKenmerk))) {
            unset($this->machtigingsKenmerk);
        } else {
            $this->machtigingsKenmerk = $machtigingsKenmerk;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\SwitchAbonnementResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
