<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for searchSmartcodeResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: error1: Op basis van de smartcode is geen abonnement gevonden
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class SearchSmartcodeResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The abonnementNummer
     * Meta informations extracted from the WSDL
     * - documentation: Het abonnementnummer van het abonnement behorende bij de smartcode.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $abonnementNummer;
    /**
     * Constructor method for searchSmartcodeResponse
     * @uses SearchSmartcodeResponse::setRequestTag()
     * @uses SearchSmartcodeResponse::setAbonnementNummer()
     * @param string $requestTag
     * @param int $abonnementNummer
     */
    public function __construct($requestTag = null, $abonnementNummer = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setAbonnementNummer($abonnementNummer);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \WebApiV4\StructType\SearchSmartcodeResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get abonnementNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAbonnementNummer()
    {
        return isset($this->abonnementNummer) ? $this->abonnementNummer : null;
    }
    /**
     * Set abonnementNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $abonnementNummer
     * @return \WebApiV4\StructType\SearchSmartcodeResponse
     */
    public function setAbonnementNummer($abonnementNummer = null)
    {
        // validation for constraint: int
        if (!is_null($abonnementNummer) && !(is_int($abonnementNummer) || ctype_digit($abonnementNummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($abonnementNummer, true), gettype($abonnementNummer)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($abonnementNummer) && mb_strlen(preg_replace('/(\D)/', '', $abonnementNummer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($abonnementNummer, true), mb_strlen(preg_replace('/(\D)/', '', $abonnementNummer))), __LINE__);
        }
        if (is_null($abonnementNummer) || (is_array($abonnementNummer) && empty($abonnementNummer))) {
            unset($this->abonnementNummer);
        } else {
            $this->abonnementNummer = $abonnementNummer;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\SearchSmartcodeResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
