<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for searchRelNoByEmailRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Geeft een lijst met relatienummers terug die het opgegeven e-mail adres hebben.
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class SearchRelNoByEmailRequest extends AbstractStructBase
{
    /**
     * The emailAdres
     * Meta informations extracted from the WSDL
     * - documentation: E-mail adres.
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $emailAdres;
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The zoekInVeld
     * Meta informations extracted from the WSDL
     * - documentation: [0,1,2,3,4] In welk e-mail adres veld moet er gezocht worden? 0 = beide (default) 1 = in e-mail adres veld 1, 2 = in e-mail adres veld 2, 3 = in e-mail adres veld 3, 4 = in e-mail adres veld 4.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $zoekInVeld;
    /**
     * Constructor method for searchRelNoByEmailRequest
     * @uses SearchRelNoByEmailRequest::setEmailAdres()
     * @uses SearchRelNoByEmailRequest::setRequestTag()
     * @uses SearchRelNoByEmailRequest::setZoekInVeld()
     * @param string $emailAdres
     * @param string $requestTag
     * @param float $zoekInVeld
     */
    public function __construct($emailAdres = null, $requestTag = null, $zoekInVeld = null)
    {
        $this
            ->setEmailAdres($emailAdres)
            ->setRequestTag($requestTag)
            ->setZoekInVeld($zoekInVeld);
    }
    /**
     * Get emailAdres value
     * @return string
     */
    public function getEmailAdres()
    {
        return $this->emailAdres;
    }
    /**
     * Set emailAdres value
     * @param string $emailAdres
     * @return \WebApiV4\StructType\SearchRelNoByEmailRequest
     */
    public function setEmailAdres($emailAdres = null)
    {
        // validation for constraint: string
        if (!is_null($emailAdres) && !is_string($emailAdres)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailAdres, true), gettype($emailAdres)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($emailAdres) && mb_strlen($emailAdres) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($emailAdres)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($emailAdres) && mb_strlen($emailAdres) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($emailAdres)), __LINE__);
        }
        $this->emailAdres = $emailAdres;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \WebApiV4\StructType\SearchRelNoByEmailRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get zoekInVeld value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getZoekInVeld()
    {
        return isset($this->zoekInVeld) ? $this->zoekInVeld : null;
    }
    /**
     * Set zoekInVeld value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $zoekInVeld
     * @return \WebApiV4\StructType\SearchRelNoByEmailRequest
     */
    public function setZoekInVeld($zoekInVeld = null)
    {
        // validation for constraint: float
        if (!is_null($zoekInVeld) && !(is_float($zoekInVeld) || is_numeric($zoekInVeld))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($zoekInVeld, true), gettype($zoekInVeld)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($zoekInVeld) && mb_strlen(preg_replace('/(\D)/', '', $zoekInVeld)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($zoekInVeld, true), mb_strlen(preg_replace('/(\D)/', '', $zoekInVeld))), __LINE__);
        }
        if (is_null($zoekInVeld) || (is_array($zoekInVeld) && empty($zoekInVeld))) {
            unset($this->zoekInVeld);
        } else {
            $this->zoekInVeld = $zoekInVeld;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\SearchRelNoByEmailRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
