<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for renewAbonnementRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Een bestaand, gestopt abonnement, renewen
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class RenewAbonnementRequest extends AbstractStructBase
{
    /**
     * The aboNo
     * Meta informations extracted from the WSDL
     * - documentation: Abonnementnummer van het abonnement dat renewed moet worden
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $aboNo;
    /**
     * The renewPerWanneer
     * Meta informations extracted from the WSDL
     * - documentation: {aansluitend,eerstvolgende_editie,specifieke_editie}Per wanneer moet het renewal-abonnement ingaan? <ul><li>aansluitend: Het renewalabonnement sluit aan op het huidige abonnement. Indien er al nummers verschenen zijn, worden deze
     * nagestuurd</li><li>eerstvolgende_editie: Het renewal abonnement start per de eerstvolgende editie die verschijnt</li><li>specifieke_editie: Het renewal abonnement start op de editie, opgegeven in renewPerEditie</li></ul>
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $renewPerWanneer;
    /**
     * The renewNaarAbonnement
     * Meta informations extracted from the WSDL
     * - documentation: {zelfde,ander} Geeft aan wat voor soort abonnement het renewalabonnement krijgt. <ul><li>zelfde: het renewalabonnement krijgt dezelfde abonnementsoort en pakket als het oorspronkelijke abonnement</li><li>ander: Het abonnement wordt
     * gerenewed naar een andere soort. Geef in een van de velden renewNaarAbosoortCode, renewNaarActieCode of renewNaarPekketCode de juiste soort door</li></ul>
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $renewNaarAbonnement;
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij.<br/> De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The renewPerEditie
     * Meta informations extracted from the WSDL
     * - documentation: Indien renewPerWanneer=specifieke_editie, kan hier het editienummer opgegeven worden per wanneer het renewalabonnement gestart moet worden. Editienummer opgeven in de vorm yyyynn(n)
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $renewPerEditie;
    /**
     * The renewNaarAbosoortCode
     * Meta informations extracted from the WSDL
     * - documentation: Wordt alleen gebruikt indien renewNaarAbonnement=ander. Code van de abonnementsoort waar het abonnement naartoe gerenewed moet worden
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $renewNaarAbosoortCode;
    /**
     * The renewNaarActieCode
     * Meta informations extracted from the WSDL
     * - documentation: Wordt alleen gebruikt indien renewNaarAbonnement=ander. Code van de actie waar het abonnement naartoe gerenewed moet worden
     * - base: xsd:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $renewNaarActieCode;
    /**
     * The renewNaarPakketCode
     * Meta informations extracted from the WSDL
     * - documentation: Wordt alleen gebruikt indien renewNaarAbonnement=ander. Code van het pakket waar het abonnement naartoe gerenewed moet worden
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $renewNaarPakketCode;
    /**
     * Constructor method for renewAbonnementRequest
     * @uses RenewAbonnementRequest::setAboNo()
     * @uses RenewAbonnementRequest::setRenewPerWanneer()
     * @uses RenewAbonnementRequest::setRenewNaarAbonnement()
     * @uses RenewAbonnementRequest::setRequestTag()
     * @uses RenewAbonnementRequest::setRenewPerEditie()
     * @uses RenewAbonnementRequest::setRenewNaarAbosoortCode()
     * @uses RenewAbonnementRequest::setRenewNaarActieCode()
     * @uses RenewAbonnementRequest::setRenewNaarPakketCode()
     * @param int $aboNo
     * @param string $renewPerWanneer
     * @param string $renewNaarAbonnement
     * @param string $requestTag
     * @param int $renewPerEditie
     * @param string $renewNaarAbosoortCode
     * @param string $renewNaarActieCode
     * @param string $renewNaarPakketCode
     */
    public function __construct($aboNo = null, $renewPerWanneer = null, $renewNaarAbonnement = null, $requestTag = null, $renewPerEditie = null, $renewNaarAbosoortCode = null, $renewNaarActieCode = null, $renewNaarPakketCode = null)
    {
        $this
            ->setAboNo($aboNo)
            ->setRenewPerWanneer($renewPerWanneer)
            ->setRenewNaarAbonnement($renewNaarAbonnement)
            ->setRequestTag($requestTag)
            ->setRenewPerEditie($renewPerEditie)
            ->setRenewNaarAbosoortCode($renewNaarAbosoortCode)
            ->setRenewNaarActieCode($renewNaarActieCode)
            ->setRenewNaarPakketCode($renewNaarPakketCode);
    }
    /**
     * Get aboNo value
     * @return int
     */
    public function getAboNo()
    {
        return $this->aboNo;
    }
    /**
     * Set aboNo value
     * @param int $aboNo
     * @return \WebApiV4\StructType\RenewAbonnementRequest
     */
    public function setAboNo($aboNo = null)
    {
        // validation for constraint: int
        if (!is_null($aboNo) && !(is_int($aboNo) || ctype_digit($aboNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aboNo, true), gettype($aboNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($aboNo) && mb_strlen(preg_replace('/(\D)/', '', $aboNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($aboNo, true), mb_strlen(preg_replace('/(\D)/', '', $aboNo))), __LINE__);
        }
        $this->aboNo = $aboNo;
        return $this;
    }
    /**
     * Get renewPerWanneer value
     * @return string
     */
    public function getRenewPerWanneer()
    {
        return $this->renewPerWanneer;
    }
    /**
     * Set renewPerWanneer value
     * @param string $renewPerWanneer
     * @return \WebApiV4\StructType\RenewAbonnementRequest
     */
    public function setRenewPerWanneer($renewPerWanneer = null)
    {
        // validation for constraint: string
        if (!is_null($renewPerWanneer) && !is_string($renewPerWanneer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($renewPerWanneer, true), gettype($renewPerWanneer)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($renewPerWanneer) && mb_strlen($renewPerWanneer) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($renewPerWanneer)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($renewPerWanneer) && mb_strlen($renewPerWanneer) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($renewPerWanneer)), __LINE__);
        }
        $this->renewPerWanneer = $renewPerWanneer;
        return $this;
    }
    /**
     * Get renewNaarAbonnement value
     * @return string
     */
    public function getRenewNaarAbonnement()
    {
        return $this->renewNaarAbonnement;
    }
    /**
     * Set renewNaarAbonnement value
     * @param string $renewNaarAbonnement
     * @return \WebApiV4\StructType\RenewAbonnementRequest
     */
    public function setRenewNaarAbonnement($renewNaarAbonnement = null)
    {
        // validation for constraint: string
        if (!is_null($renewNaarAbonnement) && !is_string($renewNaarAbonnement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($renewNaarAbonnement, true), gettype($renewNaarAbonnement)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($renewNaarAbonnement) && mb_strlen($renewNaarAbonnement) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($renewNaarAbonnement)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($renewNaarAbonnement) && mb_strlen($renewNaarAbonnement) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($renewNaarAbonnement)), __LINE__);
        }
        $this->renewNaarAbonnement = $renewNaarAbonnement;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \WebApiV4\StructType\RenewAbonnementRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get renewPerEditie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRenewPerEditie()
    {
        return isset($this->renewPerEditie) ? $this->renewPerEditie : null;
    }
    /**
     * Set renewPerEditie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $renewPerEditie
     * @return \WebApiV4\StructType\RenewAbonnementRequest
     */
    public function setRenewPerEditie($renewPerEditie = null)
    {
        // validation for constraint: int
        if (!is_null($renewPerEditie) && !(is_int($renewPerEditie) || ctype_digit($renewPerEditie))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($renewPerEditie, true), gettype($renewPerEditie)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($renewPerEditie) && mb_strlen(preg_replace('/(\D)/', '', $renewPerEditie)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($renewPerEditie, true), mb_strlen(preg_replace('/(\D)/', '', $renewPerEditie))), __LINE__);
        }
        if (is_null($renewPerEditie) || (is_array($renewPerEditie) && empty($renewPerEditie))) {
            unset($this->renewPerEditie);
        } else {
            $this->renewPerEditie = $renewPerEditie;
        }
        return $this;
    }
    /**
     * Get renewNaarAbosoortCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRenewNaarAbosoortCode()
    {
        return isset($this->renewNaarAbosoortCode) ? $this->renewNaarAbosoortCode : null;
    }
    /**
     * Set renewNaarAbosoortCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $renewNaarAbosoortCode
     * @return \WebApiV4\StructType\RenewAbonnementRequest
     */
    public function setRenewNaarAbosoortCode($renewNaarAbosoortCode = null)
    {
        // validation for constraint: string
        if (!is_null($renewNaarAbosoortCode) && !is_string($renewNaarAbosoortCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($renewNaarAbosoortCode, true), gettype($renewNaarAbosoortCode)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($renewNaarAbosoortCode) && mb_strlen($renewNaarAbosoortCode) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($renewNaarAbosoortCode)), __LINE__);
        }
        if (is_null($renewNaarAbosoortCode) || (is_array($renewNaarAbosoortCode) && empty($renewNaarAbosoortCode))) {
            unset($this->renewNaarAbosoortCode);
        } else {
            $this->renewNaarAbosoortCode = $renewNaarAbosoortCode;
        }
        return $this;
    }
    /**
     * Get renewNaarActieCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRenewNaarActieCode()
    {
        return isset($this->renewNaarActieCode) ? $this->renewNaarActieCode : null;
    }
    /**
     * Set renewNaarActieCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $renewNaarActieCode
     * @return \WebApiV4\StructType\RenewAbonnementRequest
     */
    public function setRenewNaarActieCode($renewNaarActieCode = null)
    {
        // validation for constraint: string
        if (!is_null($renewNaarActieCode) && !is_string($renewNaarActieCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($renewNaarActieCode, true), gettype($renewNaarActieCode)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($renewNaarActieCode) && mb_strlen($renewNaarActieCode) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($renewNaarActieCode)), __LINE__);
        }
        if (is_null($renewNaarActieCode) || (is_array($renewNaarActieCode) && empty($renewNaarActieCode))) {
            unset($this->renewNaarActieCode);
        } else {
            $this->renewNaarActieCode = $renewNaarActieCode;
        }
        return $this;
    }
    /**
     * Get renewNaarPakketCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRenewNaarPakketCode()
    {
        return isset($this->renewNaarPakketCode) ? $this->renewNaarPakketCode : null;
    }
    /**
     * Set renewNaarPakketCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $renewNaarPakketCode
     * @return \WebApiV4\StructType\RenewAbonnementRequest
     */
    public function setRenewNaarPakketCode($renewNaarPakketCode = null)
    {
        // validation for constraint: string
        if (!is_null($renewNaarPakketCode) && !is_string($renewNaarPakketCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($renewNaarPakketCode, true), gettype($renewNaarPakketCode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($renewNaarPakketCode) && mb_strlen($renewNaarPakketCode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($renewNaarPakketCode)), __LINE__);
        }
        if (is_null($renewNaarPakketCode) || (is_array($renewNaarPakketCode) && empty($renewNaarPakketCode))) {
            unset($this->renewNaarPakketCode);
        } else {
            $this->renewNaarPakketCode = $renewNaarPakketCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\RenewAbonnementRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
