<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HerkomstV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Herkomst object.
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class HerkomstV4 extends AbstractStructBase
{
    /**
     * The herkomstCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van de herkomst.
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $herkomstCode;
    /**
     * The omschrijving
     * Meta informations extracted from the WSDL
     * - documentation: Korte omschrijving van de herkomst.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $omschrijving;
    /**
     * The omschrijvingUitgebreid
     * Meta informations extracted from the WSDL
     * - documentation: Uitgebreide omschrijving van de herkomst voor op de website.
     * - base: xsd:string
     * - maxLength: 2000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $omschrijvingUitgebreid;
    /**
     * Constructor method for HerkomstV4
     * @uses HerkomstV4::setHerkomstCode()
     * @uses HerkomstV4::setOmschrijving()
     * @uses HerkomstV4::setOmschrijvingUitgebreid()
     * @param string $herkomstCode
     * @param string $omschrijving
     * @param string $omschrijvingUitgebreid
     */
    public function __construct($herkomstCode = null, $omschrijving = null, $omschrijvingUitgebreid = null)
    {
        $this
            ->setHerkomstCode($herkomstCode)
            ->setOmschrijving($omschrijving)
            ->setOmschrijvingUitgebreid($omschrijvingUitgebreid);
    }
    /**
     * Get herkomstCode value
     * @return string
     */
    public function getHerkomstCode()
    {
        return $this->herkomstCode;
    }
    /**
     * Set herkomstCode value
     * @param string $herkomstCode
     * @return \WebApiV4\StructType\HerkomstV4
     */
    public function setHerkomstCode($herkomstCode = null)
    {
        // validation for constraint: string
        if (!is_null($herkomstCode) && !is_string($herkomstCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($herkomstCode, true), gettype($herkomstCode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($herkomstCode) && mb_strlen($herkomstCode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($herkomstCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($herkomstCode) && mb_strlen($herkomstCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($herkomstCode)), __LINE__);
        }
        $this->herkomstCode = $herkomstCode;
        return $this;
    }
    /**
     * Get omschrijving value
     * @return string
     */
    public function getOmschrijving()
    {
        return $this->omschrijving;
    }
    /**
     * Set omschrijving value
     * @param string $omschrijving
     * @return \WebApiV4\StructType\HerkomstV4
     */
    public function setOmschrijving($omschrijving = null)
    {
        // validation for constraint: string
        if (!is_null($omschrijving) && !is_string($omschrijving)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($omschrijving, true), gettype($omschrijving)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($omschrijving) && mb_strlen($omschrijving) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($omschrijving)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($omschrijving) && mb_strlen($omschrijving) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($omschrijving)), __LINE__);
        }
        $this->omschrijving = $omschrijving;
        return $this;
    }
    /**
     * Get omschrijvingUitgebreid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOmschrijvingUitgebreid()
    {
        return isset($this->omschrijvingUitgebreid) ? $this->omschrijvingUitgebreid : null;
    }
    /**
     * Set omschrijvingUitgebreid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $omschrijvingUitgebreid
     * @return \WebApiV4\StructType\HerkomstV4
     */
    public function setOmschrijvingUitgebreid($omschrijvingUitgebreid = null)
    {
        // validation for constraint: string
        if (!is_null($omschrijvingUitgebreid) && !is_string($omschrijvingUitgebreid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($omschrijvingUitgebreid, true), gettype($omschrijvingUitgebreid)), __LINE__);
        }
        // validation for constraint: maxLength(2000)
        if (!is_null($omschrijvingUitgebreid) && mb_strlen($omschrijvingUitgebreid) > 2000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2000', mb_strlen($omschrijvingUitgebreid)), __LINE__);
        }
        if (is_null($omschrijvingUitgebreid) || (is_array($omschrijvingUitgebreid) && empty($omschrijvingUitgebreid))) {
            unset($this->omschrijvingUitgebreid);
        } else {
            $this->omschrijvingUitgebreid = $omschrijvingUitgebreid;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\HerkomstV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
