<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getUitgaveInfoRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Geeft een lijst met uitgaven terug.
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class GetUitgaveInfoRequest extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The uitgaveCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van de uitgave waarvan de informatie wordt opgevraagd. Indien leeg worden van alle uitgaven de gegevens opgehaald.
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $uitgaveCode;
    /**
     * The inclusiefInactieveUitgaven
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie ook inactieve uitgaven ophalen. false (Default) = Alleen actieve. true = Ook inactieve.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $inclusiefInactieveUitgaven;
    /**
     * The inclusiefInactieveAbosoorten
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie ook inactieve abonnementsoorten ophalen. false (Default) = Alleen actieve. true = Ook inactieve.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $inclusiefInactieveAbosoorten;
    /**
     * Constructor method for getUitgaveInfoRequest
     * @uses GetUitgaveInfoRequest::setRequestTag()
     * @uses GetUitgaveInfoRequest::setUitgaveCode()
     * @uses GetUitgaveInfoRequest::setInclusiefInactieveUitgaven()
     * @uses GetUitgaveInfoRequest::setInclusiefInactieveAbosoorten()
     * @param string $requestTag
     * @param string $uitgaveCode
     * @param bool $inclusiefInactieveUitgaven
     * @param bool $inclusiefInactieveAbosoorten
     */
    public function __construct($requestTag = null, $uitgaveCode = null, $inclusiefInactieveUitgaven = null, $inclusiefInactieveAbosoorten = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setUitgaveCode($uitgaveCode)
            ->setInclusiefInactieveUitgaven($inclusiefInactieveUitgaven)
            ->setInclusiefInactieveAbosoorten($inclusiefInactieveAbosoorten);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \WebApiV4\StructType\GetUitgaveInfoRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get uitgaveCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUitgaveCode()
    {
        return isset($this->uitgaveCode) ? $this->uitgaveCode : null;
    }
    /**
     * Set uitgaveCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uitgaveCode
     * @return \WebApiV4\StructType\GetUitgaveInfoRequest
     */
    public function setUitgaveCode($uitgaveCode = null)
    {
        // validation for constraint: string
        if (!is_null($uitgaveCode) && !is_string($uitgaveCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uitgaveCode, true), gettype($uitgaveCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($uitgaveCode) && mb_strlen($uitgaveCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($uitgaveCode)), __LINE__);
        }
        if (is_null($uitgaveCode) || (is_array($uitgaveCode) && empty($uitgaveCode))) {
            unset($this->uitgaveCode);
        } else {
            $this->uitgaveCode = $uitgaveCode;
        }
        return $this;
    }
    /**
     * Get inclusiefInactieveUitgaven value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getInclusiefInactieveUitgaven()
    {
        return isset($this->inclusiefInactieveUitgaven) ? $this->inclusiefInactieveUitgaven : null;
    }
    /**
     * Set inclusiefInactieveUitgaven value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $inclusiefInactieveUitgaven
     * @return \WebApiV4\StructType\GetUitgaveInfoRequest
     */
    public function setInclusiefInactieveUitgaven($inclusiefInactieveUitgaven = null)
    {
        // validation for constraint: boolean
        if (!is_null($inclusiefInactieveUitgaven) && !is_bool($inclusiefInactieveUitgaven)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inclusiefInactieveUitgaven, true), gettype($inclusiefInactieveUitgaven)), __LINE__);
        }
        if (is_null($inclusiefInactieveUitgaven) || (is_array($inclusiefInactieveUitgaven) && empty($inclusiefInactieveUitgaven))) {
            unset($this->inclusiefInactieveUitgaven);
        } else {
            $this->inclusiefInactieveUitgaven = $inclusiefInactieveUitgaven;
        }
        return $this;
    }
    /**
     * Get inclusiefInactieveAbosoorten value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getInclusiefInactieveAbosoorten()
    {
        return isset($this->inclusiefInactieveAbosoorten) ? $this->inclusiefInactieveAbosoorten : null;
    }
    /**
     * Set inclusiefInactieveAbosoorten value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $inclusiefInactieveAbosoorten
     * @return \WebApiV4\StructType\GetUitgaveInfoRequest
     */
    public function setInclusiefInactieveAbosoorten($inclusiefInactieveAbosoorten = null)
    {
        // validation for constraint: boolean
        if (!is_null($inclusiefInactieveAbosoorten) && !is_bool($inclusiefInactieveAbosoorten)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inclusiefInactieveAbosoorten, true), gettype($inclusiefInactieveAbosoorten)), __LINE__);
        }
        if (is_null($inclusiefInactieveAbosoorten) || (is_array($inclusiefInactieveAbosoorten) && empty($inclusiefInactieveAbosoorten))) {
            unset($this->inclusiefInactieveAbosoorten);
        } else {
            $this->inclusiefInactieveAbosoorten = $inclusiefInactieveAbosoorten;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\GetUitgaveInfoRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
