<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getSwitchPropositiesResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: error180: Geen geldig switchmogelijkheid gevonden | error96: De einddatum van de actie is verstreken | error95: De ingangsdatum van de actie is nog niet ingegaan | error85: Het is niet mogelijk een proefabonnement aan te maken |
 * error84: Voor de abonnee is al een actief abonnement met dezelfde uitgave aanwezig (deze melding kan dus niet optreden als geenControleLopendAbo als 1 meegegeven is in het request) | error57: De actie is niet actief | error34: De actie is niet
 * gevonden | error12: Er is geen abonnement opgegeven | error1: Het abonnement is niet gevonden
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class GetSwitchPropositiesResponse extends AbstractStructBase
{
    /**
     * The aboNo
     * Meta informations extracted from the WSDL
     * - documentation: Nummer van het abonnement waarvoor de proposities worden opgevraagd.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $aboNo;
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The startDatum
     * Meta informations extracted from the WSDL
     * - documentation: Datum per wanneer er geswitcht kan worden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $startDatum;
    /**
     * The proposities
     * Meta informations extracted from the WSDL
     * - documentation: Een lijst met mogelijke proposities waar naartoe er geswitcht mag worden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \WebApiV4\StructType\PropositieTabV4
     */
    public $proposities;
    /**
     * Constructor method for getSwitchPropositiesResponse
     * @uses GetSwitchPropositiesResponse::setAboNo()
     * @uses GetSwitchPropositiesResponse::setRequestTag()
     * @uses GetSwitchPropositiesResponse::setStartDatum()
     * @uses GetSwitchPropositiesResponse::setProposities()
     * @param int $aboNo
     * @param string $requestTag
     * @param string $startDatum
     * @param \WebApiV4\StructType\PropositieTabV4 $proposities
     */
    public function __construct($aboNo = null, $requestTag = null, $startDatum = null, \WebApiV4\StructType\PropositieTabV4 $proposities = null)
    {
        $this
            ->setAboNo($aboNo)
            ->setRequestTag($requestTag)
            ->setStartDatum($startDatum)
            ->setProposities($proposities);
    }
    /**
     * Get aboNo value
     * @return int
     */
    public function getAboNo()
    {
        return $this->aboNo;
    }
    /**
     * Set aboNo value
     * @param int $aboNo
     * @return \WebApiV4\StructType\GetSwitchPropositiesResponse
     */
    public function setAboNo($aboNo = null)
    {
        // validation for constraint: int
        if (!is_null($aboNo) && !(is_int($aboNo) || ctype_digit($aboNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aboNo, true), gettype($aboNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($aboNo) && mb_strlen(preg_replace('/(\D)/', '', $aboNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($aboNo, true), mb_strlen(preg_replace('/(\D)/', '', $aboNo))), __LINE__);
        }
        $this->aboNo = $aboNo;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \WebApiV4\StructType\GetSwitchPropositiesResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get startDatum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartDatum()
    {
        return isset($this->startDatum) ? $this->startDatum : null;
    }
    /**
     * Set startDatum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startDatum
     * @return \WebApiV4\StructType\GetSwitchPropositiesResponse
     */
    public function setStartDatum($startDatum = null)
    {
        // validation for constraint: string
        if (!is_null($startDatum) && !is_string($startDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDatum, true), gettype($startDatum)), __LINE__);
        }
        if (is_null($startDatum) || (is_array($startDatum) && empty($startDatum))) {
            unset($this->startDatum);
        } else {
            $this->startDatum = $startDatum;
        }
        return $this;
    }
    /**
     * Get proposities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \WebApiV4\StructType\PropositieTabV4|null
     */
    public function getProposities()
    {
        return isset($this->proposities) ? $this->proposities : null;
    }
    /**
     * Set proposities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \WebApiV4\StructType\PropositieTabV4 $proposities
     * @return \WebApiV4\StructType\GetSwitchPropositiesResponse
     */
    public function setProposities(\WebApiV4\StructType\PropositieTabV4 $proposities = null)
    {
        if (is_null($proposities) || (is_array($proposities) && empty($proposities))) {
            unset($this->proposities);
        } else {
            $this->proposities = $proposities;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\GetSwitchPropositiesResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
