<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createVerhuizingResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: error402: Levering in het buitenland niet toegestaan voor dit abonnement | error401: Verhuizing is niet toegestaan voor dit abonnement | error129: Datum heeft een verkeerd formaat of kan niet tot een bestaande datum worden herleid |
 * error124: Bij een verhuizing is een ingangsdatum verplicht | error81: Het adres is niet gevonden in de postcodetabel | error72: Voor een provincie is een land verplicht | error69: De provincie is niet gekoppeld aan het land | error66: De provincie is
 * niet gevonden | error32: De adresgegevens ontbreken | error30: De adresgegevens zijn niet compleet | error19: Er is geen relatie opgegeven | error7: Adrestype is niet bekend | error6: Mutaties moeten in de toekomst liggen | error5: De relatie is niet
 * gevonden | error2: Het land is niet gevonden
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class CreateVerhuizingResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The datumIngang
     * Meta informations extracted from the WSDL
     * - documentation: Daadwerkelijke ingangsdatum van de vakantieregeling. Indien een ingangsdatum opgegeven is die kleiner is dan de verschijningsdatum van een van de actieve abonnementen van de relatie wordt de eerste verschijningsdatum als ingangsdatum
     * genomen.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $datumIngang;
    /**
     * The relNoResult
     * Meta informations extracted from the WSDL
     * - documentation: Relatienummer van gebruikte relatie (kan afwijken van relNo input in geval van ontdubbelde relatie).
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relNoResult;
    /**
     * The toekMutNo
     * Meta informations extracted from the WSDL
     * - documentation: Identifier die de aangemaakte verhuizing uniek identificeert.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $toekMutNo;
    /**
     * Constructor method for createVerhuizingResponse
     * @uses CreateVerhuizingResponse::setRequestTag()
     * @uses CreateVerhuizingResponse::setDatumIngang()
     * @uses CreateVerhuizingResponse::setRelNoResult()
     * @uses CreateVerhuizingResponse::setToekMutNo()
     * @param string $requestTag
     * @param string $datumIngang
     * @param int $relNoResult
     * @param int $toekMutNo
     */
    public function __construct($requestTag = null, $datumIngang = null, $relNoResult = null, $toekMutNo = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setDatumIngang($datumIngang)
            ->setRelNoResult($relNoResult)
            ->setToekMutNo($toekMutNo);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \WebApiV4\StructType\CreateVerhuizingResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get datumIngang value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatumIngang()
    {
        return isset($this->datumIngang) ? $this->datumIngang : null;
    }
    /**
     * Set datumIngang value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $datumIngang
     * @return \WebApiV4\StructType\CreateVerhuizingResponse
     */
    public function setDatumIngang($datumIngang = null)
    {
        // validation for constraint: string
        if (!is_null($datumIngang) && !is_string($datumIngang)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumIngang, true), gettype($datumIngang)), __LINE__);
        }
        if (is_null($datumIngang) || (is_array($datumIngang) && empty($datumIngang))) {
            unset($this->datumIngang);
        } else {
            $this->datumIngang = $datumIngang;
        }
        return $this;
    }
    /**
     * Get relNoResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelNoResult()
    {
        return isset($this->relNoResult) ? $this->relNoResult : null;
    }
    /**
     * Set relNoResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relNoResult
     * @return \WebApiV4\StructType\CreateVerhuizingResponse
     */
    public function setRelNoResult($relNoResult = null)
    {
        // validation for constraint: int
        if (!is_null($relNoResult) && !(is_int($relNoResult) || ctype_digit($relNoResult))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relNoResult, true), gettype($relNoResult)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relNoResult) && mb_strlen(preg_replace('/(\D)/', '', $relNoResult)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relNoResult, true), mb_strlen(preg_replace('/(\D)/', '', $relNoResult))), __LINE__);
        }
        if (is_null($relNoResult) || (is_array($relNoResult) && empty($relNoResult))) {
            unset($this->relNoResult);
        } else {
            $this->relNoResult = $relNoResult;
        }
        return $this;
    }
    /**
     * Get toekMutNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getToekMutNo()
    {
        return isset($this->toekMutNo) ? $this->toekMutNo : null;
    }
    /**
     * Set toekMutNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $toekMutNo
     * @return \WebApiV4\StructType\CreateVerhuizingResponse
     */
    public function setToekMutNo($toekMutNo = null)
    {
        // validation for constraint: int
        if (!is_null($toekMutNo) && !(is_int($toekMutNo) || ctype_digit($toekMutNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($toekMutNo, true), gettype($toekMutNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($toekMutNo) && mb_strlen(preg_replace('/(\D)/', '', $toekMutNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($toekMutNo, true), mb_strlen(preg_replace('/(\D)/', '', $toekMutNo))), __LINE__);
        }
        if (is_null($toekMutNo) || (is_array($toekMutNo) && empty($toekMutNo))) {
            unset($this->toekMutNo);
        } else {
            $this->toekMutNo = $toekMutNo;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\CreateVerhuizingResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
