<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createVakantieRegelingResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: error507: In de opgegeven periode staat al een vakantieregeling genoteerd | error506: Levering in het buitenland niet toegestaan voor dit abonnement | error505: De instellingen bij de abonnementsoort voor de vakantieregeling zijn
 * ongeldig | error504: Bij de abonnementsoort ontbreken instellingen om te bepalen of de vakantieregeling toegestaan is | error503: De onderbreking ligt te dicht bij een voorgaande of opvolgende onderbreking | error502: Vakantieregeling is niet
 * toegestaan voor dit type abonnement | error265: Doorgifte van een tijdelijke afdelingsnaam alleen toegestaan bij regeling type 4 (Vakantieadres) | error190: Regeling is niet toegestaan, de einddatum ligt na de stopdatum van het abonnement | error189:
 * Regeling is niet toegestaan, de ingangsdatum ligt voor de startdatum van het abonnement | error129: Datum heeft een verkeerd formaat of kan niet tot een bestaande datum worden herleid | error113: Ongeldige lengte voor de vakantieregeling opgegeven |
 * error112: Bij een vakantieregeling is een einddatum verplicht | error111: Bij een vakantieregeling is een ingangsdatum verplicht | error110: Onderbreking is niet toegestaan, het abonnement heeft een einddatum | error104: Het opgegeven geslacht is
 * niet geldig | error88: De opgegeven geboortedatum is niet geldig | error87: Het opgegeven regelingtype voor de vakantieregeling is niet bekend | error86: De einddatum mag niet voor de ingangsdatum van de vakantieregeling liggen | error81: Het adres
 * is niet gevonden in de postcodetabel | error72: Voor een provincie is een land verplicht | error69: De provincie is niet gekoppeld aan het land | error66: De provincie is niet gevonden | error63: Het mobiele telefoonnummer is niet geldig | error62:
 * De titulatuur is niet bekend | error59: Er zijn meerdere kandidaten gevonden | error38: Het telefoonnummer is niet geldig | error32: De adresgegevens ontbreken | error31: Het e-mail adres voldoet niet aan de eisen | error30: De adresgegevens zijn
 * niet compleet | error28: Bij een relatie is een naam verplicht | error12: Er is geen abonnement opgegeven | error6: Mutaties moeten in de toekomst liggen | error2: Het land is niet gevonden | error1: Het abonnement is niet gevonden
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class CreateVakantieRegelingResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The datumIngang
     * Meta informations extracted from the WSDL
     * - documentation: Daadwerkelijke ingangsdatum van de vakantieregeling. Indien een ingangsdatum opgegeven is die kleiner is dan de verschijningsdatum van het abonnement (of abonnementen in geval van een pakket) deze verschijningsdatum als ingangsdatum
     * genomen.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $datumIngang;
    /**
     * The isNieuweRelatie
     * Meta informations extracted from the WSDL
     * - documentation: [vakantieRegelingType = 5 (doorsturen)] Geeft aan of er een nieuwe relatie is aangemaakt of dat er een bestaande relatie gebruikt is.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $isNieuweRelatie;
    /**
     * The relNo
     * Meta informations extracted from the WSDL
     * - documentation: [vakantieRegelingType = 5 (doorsturen)] Het relatienummer van de relatie.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relNo;
    /**
     * The toekMutNo
     * Meta informations extracted from the WSDL
     * - documentation: Identifier die de vakantieregeling uniek identificeert.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $toekMutNo;
    /**
     * Constructor method for createVakantieRegelingResponse
     * @uses CreateVakantieRegelingResponse::setRequestTag()
     * @uses CreateVakantieRegelingResponse::setDatumIngang()
     * @uses CreateVakantieRegelingResponse::setIsNieuweRelatie()
     * @uses CreateVakantieRegelingResponse::setRelNo()
     * @uses CreateVakantieRegelingResponse::setToekMutNo()
     * @param string $requestTag
     * @param string $datumIngang
     * @param bool $isNieuweRelatie
     * @param int $relNo
     * @param int $toekMutNo
     */
    public function __construct($requestTag = null, $datumIngang = null, $isNieuweRelatie = null, $relNo = null, $toekMutNo = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setDatumIngang($datumIngang)
            ->setIsNieuweRelatie($isNieuweRelatie)
            ->setRelNo($relNo)
            ->setToekMutNo($toekMutNo);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \WebApiV4\StructType\CreateVakantieRegelingResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get datumIngang value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatumIngang()
    {
        return isset($this->datumIngang) ? $this->datumIngang : null;
    }
    /**
     * Set datumIngang value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $datumIngang
     * @return \WebApiV4\StructType\CreateVakantieRegelingResponse
     */
    public function setDatumIngang($datumIngang = null)
    {
        // validation for constraint: string
        if (!is_null($datumIngang) && !is_string($datumIngang)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumIngang, true), gettype($datumIngang)), __LINE__);
        }
        if (is_null($datumIngang) || (is_array($datumIngang) && empty($datumIngang))) {
            unset($this->datumIngang);
        } else {
            $this->datumIngang = $datumIngang;
        }
        return $this;
    }
    /**
     * Get isNieuweRelatie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsNieuweRelatie()
    {
        return isset($this->isNieuweRelatie) ? $this->isNieuweRelatie : null;
    }
    /**
     * Set isNieuweRelatie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isNieuweRelatie
     * @return \WebApiV4\StructType\CreateVakantieRegelingResponse
     */
    public function setIsNieuweRelatie($isNieuweRelatie = null)
    {
        // validation for constraint: boolean
        if (!is_null($isNieuweRelatie) && !is_bool($isNieuweRelatie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isNieuweRelatie, true), gettype($isNieuweRelatie)), __LINE__);
        }
        if (is_null($isNieuweRelatie) || (is_array($isNieuweRelatie) && empty($isNieuweRelatie))) {
            unset($this->isNieuweRelatie);
        } else {
            $this->isNieuweRelatie = $isNieuweRelatie;
        }
        return $this;
    }
    /**
     * Get relNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelNo()
    {
        return isset($this->relNo) ? $this->relNo : null;
    }
    /**
     * Set relNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relNo
     * @return \WebApiV4\StructType\CreateVakantieRegelingResponse
     */
    public function setRelNo($relNo = null)
    {
        // validation for constraint: int
        if (!is_null($relNo) && !(is_int($relNo) || ctype_digit($relNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relNo, true), gettype($relNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relNo) && mb_strlen(preg_replace('/(\D)/', '', $relNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relNo, true), mb_strlen(preg_replace('/(\D)/', '', $relNo))), __LINE__);
        }
        if (is_null($relNo) || (is_array($relNo) && empty($relNo))) {
            unset($this->relNo);
        } else {
            $this->relNo = $relNo;
        }
        return $this;
    }
    /**
     * Get toekMutNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getToekMutNo()
    {
        return isset($this->toekMutNo) ? $this->toekMutNo : null;
    }
    /**
     * Set toekMutNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $toekMutNo
     * @return \WebApiV4\StructType\CreateVakantieRegelingResponse
     */
    public function setToekMutNo($toekMutNo = null)
    {
        // validation for constraint: int
        if (!is_null($toekMutNo) && !(is_int($toekMutNo) || ctype_digit($toekMutNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($toekMutNo, true), gettype($toekMutNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($toekMutNo) && mb_strlen(preg_replace('/(\D)/', '', $toekMutNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($toekMutNo, true), mb_strlen(preg_replace('/(\D)/', '', $toekMutNo))), __LINE__);
        }
        if (is_null($toekMutNo) || (is_array($toekMutNo) && empty($toekMutNo))) {
            unset($this->toekMutNo);
        } else {
            $this->toekMutNo = $toekMutNo;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\CreateVakantieRegelingResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
