<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbonnementsoortInfoV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst met gevonden abonnementsoorten.
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class AbonnementsoortInfoV4 extends AbstractStructBase
{
    /**
     * The abonnementsoort
     * Meta informations extracted from the WSDL
     * - documentation: Lijst met gevonden abonnementsoorten.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \WebApiV4\StructType\AbonnementsoortV4[]
     */
    public $abonnementsoort;
    /**
     * Constructor method for AbonnementsoortInfoV4
     * @uses AbonnementsoortInfoV4::setAbonnementsoort()
     * @param \WebApiV4\StructType\AbonnementsoortV4[] $abonnementsoort
     */
    public function __construct(array $abonnementsoort = array())
    {
        $this
            ->setAbonnementsoort($abonnementsoort);
    }
    /**
     * Get abonnementsoort value
     * @return \WebApiV4\StructType\AbonnementsoortV4[]|null
     */
    public function getAbonnementsoort()
    {
        return $this->abonnementsoort;
    }
    /**
     * This method is responsible for validating the values passed to the setAbonnementsoort method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAbonnementsoort method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAbonnementsoortForArrayConstraintsFromSetAbonnementsoort(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $abonnementsoortInfoV4AbonnementsoortItem) {
            // validation for constraint: itemType
            if (!$abonnementsoortInfoV4AbonnementsoortItem instanceof \WebApiV4\StructType\AbonnementsoortV4) {
                $invalidValues[] = is_object($abonnementsoortInfoV4AbonnementsoortItem) ? get_class($abonnementsoortInfoV4AbonnementsoortItem) : sprintf('%s(%s)', gettype($abonnementsoortInfoV4AbonnementsoortItem), var_export($abonnementsoortInfoV4AbonnementsoortItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The abonnementsoort property can only contain items of type \WebApiV4\StructType\AbonnementsoortV4, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set abonnementsoort value
     * @throws \InvalidArgumentException
     * @param \WebApiV4\StructType\AbonnementsoortV4[] $abonnementsoort
     * @return \WebApiV4\StructType\AbonnementsoortInfoV4
     */
    public function setAbonnementsoort(array $abonnementsoort = array())
    {
        // validation for constraint: array
        if ('' !== ($abonnementsoortArrayErrorMessage = self::validateAbonnementsoortForArrayConstraintsFromSetAbonnementsoort($abonnementsoort))) {
            throw new \InvalidArgumentException($abonnementsoortArrayErrorMessage, __LINE__);
        }
        $this->abonnementsoort = $abonnementsoort;
        return $this;
    }
    /**
     * Add item to abonnementsoort value
     * @throws \InvalidArgumentException
     * @param \WebApiV4\StructType\AbonnementsoortV4 $item
     * @return \WebApiV4\StructType\AbonnementsoortInfoV4
     */
    public function addToAbonnementsoort(\WebApiV4\StructType\AbonnementsoortV4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \WebApiV4\StructType\AbonnementsoortV4) {
            throw new \InvalidArgumentException(sprintf('The abonnementsoort property can only contain items of type \WebApiV4\StructType\AbonnementsoortV4, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->abonnementsoort[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\AbonnementsoortInfoV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
