<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbonnementInfoV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst relaties met gevonden abonnementen.
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class AbonnementInfoV4 extends AbstractStructBase
{
    /**
     * The aboRelatie
     * Meta informations extracted from the WSDL
     * - documentation: Lijst relaties met gevonden abonnementen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \WebApiV4\StructType\AboRelatieV4[]
     */
    public $aboRelatie;
    /**
     * Constructor method for AbonnementInfoV4
     * @uses AbonnementInfoV4::setAboRelatie()
     * @param \WebApiV4\StructType\AboRelatieV4[] $aboRelatie
     */
    public function __construct(array $aboRelatie = array())
    {
        $this
            ->setAboRelatie($aboRelatie);
    }
    /**
     * Get aboRelatie value
     * @return \WebApiV4\StructType\AboRelatieV4[]|null
     */
    public function getAboRelatie()
    {
        return $this->aboRelatie;
    }
    /**
     * This method is responsible for validating the values passed to the setAboRelatie method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAboRelatie method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAboRelatieForArrayConstraintsFromSetAboRelatie(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $abonnementInfoV4AboRelatieItem) {
            // validation for constraint: itemType
            if (!$abonnementInfoV4AboRelatieItem instanceof \WebApiV4\StructType\AboRelatieV4) {
                $invalidValues[] = is_object($abonnementInfoV4AboRelatieItem) ? get_class($abonnementInfoV4AboRelatieItem) : sprintf('%s(%s)', gettype($abonnementInfoV4AboRelatieItem), var_export($abonnementInfoV4AboRelatieItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The aboRelatie property can only contain items of type \WebApiV4\StructType\AboRelatieV4, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set aboRelatie value
     * @throws \InvalidArgumentException
     * @param \WebApiV4\StructType\AboRelatieV4[] $aboRelatie
     * @return \WebApiV4\StructType\AbonnementInfoV4
     */
    public function setAboRelatie(array $aboRelatie = array())
    {
        // validation for constraint: array
        if ('' !== ($aboRelatieArrayErrorMessage = self::validateAboRelatieForArrayConstraintsFromSetAboRelatie($aboRelatie))) {
            throw new \InvalidArgumentException($aboRelatieArrayErrorMessage, __LINE__);
        }
        $this->aboRelatie = $aboRelatie;
        return $this;
    }
    /**
     * Add item to aboRelatie value
     * @throws \InvalidArgumentException
     * @param \WebApiV4\StructType\AboRelatieV4 $item
     * @return \WebApiV4\StructType\AbonnementInfoV4
     */
    public function addToAboRelatie(\WebApiV4\StructType\AboRelatieV4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \WebApiV4\StructType\AboRelatieV4) {
            throw new \InvalidArgumentException(sprintf('The aboRelatie property can only contain items of type \WebApiV4\StructType\AboRelatieV4, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->aboRelatie[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\AbonnementInfoV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
