<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AboInfoTabV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst met gegevens van abonnementen
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class AboInfoTabV4 extends AbstractStructBase
{
    /**
     * The abonnement
     * Meta informations extracted from the WSDL
     * - documentation: Lijst met gevonden abonnementen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \WebApiV4\StructType\AboInfoRecV4[]
     */
    public $abonnement;
    /**
     * Constructor method for AboInfoTabV4
     * @uses AboInfoTabV4::setAbonnement()
     * @param \WebApiV4\StructType\AboInfoRecV4[] $abonnement
     */
    public function __construct(array $abonnement = array())
    {
        $this
            ->setAbonnement($abonnement);
    }
    /**
     * Get abonnement value
     * @return \WebApiV4\StructType\AboInfoRecV4[]|null
     */
    public function getAbonnement()
    {
        return $this->abonnement;
    }
    /**
     * This method is responsible for validating the values passed to the setAbonnement method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAbonnement method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAbonnementForArrayConstraintsFromSetAbonnement(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $aboInfoTabV4AbonnementItem) {
            // validation for constraint: itemType
            if (!$aboInfoTabV4AbonnementItem instanceof \WebApiV4\StructType\AboInfoRecV4) {
                $invalidValues[] = is_object($aboInfoTabV4AbonnementItem) ? get_class($aboInfoTabV4AbonnementItem) : sprintf('%s(%s)', gettype($aboInfoTabV4AbonnementItem), var_export($aboInfoTabV4AbonnementItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The abonnement property can only contain items of type \WebApiV4\StructType\AboInfoRecV4, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set abonnement value
     * @throws \InvalidArgumentException
     * @param \WebApiV4\StructType\AboInfoRecV4[] $abonnement
     * @return \WebApiV4\StructType\AboInfoTabV4
     */
    public function setAbonnement(array $abonnement = array())
    {
        // validation for constraint: array
        if ('' !== ($abonnementArrayErrorMessage = self::validateAbonnementForArrayConstraintsFromSetAbonnement($abonnement))) {
            throw new \InvalidArgumentException($abonnementArrayErrorMessage, __LINE__);
        }
        $this->abonnement = $abonnement;
        return $this;
    }
    /**
     * Add item to abonnement value
     * @throws \InvalidArgumentException
     * @param \WebApiV4\StructType\AboInfoRecV4 $item
     * @return \WebApiV4\StructType\AboInfoTabV4
     */
    public function addToAbonnement(\WebApiV4\StructType\AboInfoRecV4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \WebApiV4\StructType\AboInfoRecV4) {
            throw new \InvalidArgumentException(sprintf('The abonnement property can only contain items of type \WebApiV4\StructType\AboInfoRecV4, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->abonnement[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\AboInfoTabV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
