<?php

namespace WebApiV4\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 * @date 20190723
 * @package WebApiV4
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \WebApiV4\StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\WebApiV4\StructType\Authentication $authentication, $nameSpace = 'http://zeno.socho.nl', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named getUitgaveInfo
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \WebApiV4\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Geeft een lijst met uitgaven terug.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WebApiV4\StructType\GetUitgaveInfoRequest $request_parameters
     * @return \WebApiV4\StructType\GetUitgaveInfoResponse|bool
     */
    public function getUitgaveInfo(\WebApiV4\StructType\GetUitgaveInfoRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getUitgaveInfo($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAbonnementsoortInfo
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \WebApiV4\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Ophalen van de gegevens van een of meerdere abonnementsoorten. Hierbij kan gezocht worden op basis van de abonnementsoortcode, de uitgavecode en op inactieve abonnementsoorten.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WebApiV4\StructType\GetAbonnementsoortInfoRequest $request_parameters
     * @return \WebApiV4\StructType\GetAbonnementsoortInfoResponse|bool
     */
    public function getAbonnementsoortInfo(\WebApiV4\StructType\GetAbonnementsoortInfoRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getAbonnementsoortInfo($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPakketInfo
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \WebApiV4\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Ophalen van de gegevens van een of meerdere (abonnements) pakketten. Hierbij kan gezocht worden op basis van de pakketcode en op inactieve pakketten.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WebApiV4\StructType\GetPakketInfoRequest $request_parameters
     * @return \WebApiV4\StructType\GetPakketInfoResponse|bool
     */
    public function getPakketInfo(\WebApiV4\StructType\GetPakketInfoRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getPakketInfo($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getActieInfo
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \WebApiV4\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Ophalen van gegeven svan de acties voor een bepaalde uitgave
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WebApiV4\StructType\GetActieInfoRequest $request_parameters
     * @return \WebApiV4\StructType\GetActieInfoResponse|bool
     */
    public function getActieInfo(\WebApiV4\StructType\GetActieInfoRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getActieInfo($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPropositieInfo
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \WebApiV4\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Geeft informatie terug over een propositie voor de gegeven actieCode</p> <p>In de default implementatie worden alleen gegevens terugegeven voor abonnementsoorten die bij de Actieve Stamgegevens op actief zijn gezet.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WebApiV4\StructType\GetPropositieInfoRequest $request_parameters
     * @return \WebApiV4\StructType\GetPropositieInfoResponse|bool
     */
    public function getPropositieInfo(\WebApiV4\StructType\GetPropositieInfoRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getPropositieInfo($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAbonnementInfo
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \WebApiV4\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Ophalen van abonnements informatie.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WebApiV4\StructType\GetAbonnementInfoRequest $request_parameters
     * @return \WebApiV4\StructType\GetAbonnementInfoResponse|bool
     */
    public function getAbonnementInfo(\WebApiV4\StructType\GetAbonnementInfoRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getAbonnementInfo($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRelatieAbosoortPrijs
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \WebApiV4\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Geeft de prijs terug van een abonnementsoort die voor een relatie geldterror21: De debiteur is niet gevondenerror92: De abonnementsoort is niet bekenderror93: De abonnee is niet gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WebApiV4\StructType\GetRelatieAbosoortPrijsRequest $request_parameters
     * @return \WebApiV4\StructType\GetRelatieAbosoortPrijsResponse|bool
     */
    public function getRelatieAbosoortPrijs(\WebApiV4\StructType\GetRelatieAbosoortPrijsRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getRelatieAbosoortPrijs($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCalamiteitInfo
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \WebApiV4\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Geeft informatie over calamiteiten die gelden voor de distributie van een krant naar een relatie.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WebApiV4\StructType\GetCalamiteitInfoRequest $request_parameters
     * @return \WebApiV4\StructType\GetCalamiteitInfoResponse|bool
     */
    public function getCalamiteitInfo(\WebApiV4\StructType\GetCalamiteitInfoRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getCalamiteitInfo($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCalamiteitInfoByPcHnr
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \WebApiV4\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Geeft informatie over calamiteiten die actief zijn voor de distributie van een krant op een specifiek adres.error186: Opgegeven postcode is niet geldigerror999: Deze functionaliteit is niet geimplementeerd
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WebApiV4\StructType\GetCalamiteitInfoByPcHnrRequest $request_parameters
     * @return \WebApiV4\StructType\GetCalamiteitInfoByPcHnrResponse|bool
     */
    public function getCalamiteitInfoByPcHnr(\WebApiV4\StructType\GetCalamiteitInfoByPcHnrRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getCalamiteitInfoByPcHnr($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getHerkomstInfo
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \WebApiV4\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Geeft de herkomstcodes op die gelden voor een bepaalde uitgave
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WebApiV4\StructType\GetHerkomstInfoRequest $request_parameters
     * @return \WebApiV4\StructType\GetHerkomstInfoResponse|bool
     */
    public function getHerkomstInfo(\WebApiV4\StructType\GetHerkomstInfoRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getHerkomstInfo($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVerbandInfo
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \WebApiV4\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Geeft een lijst met gekoppelde relatieverbanden terug
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WebApiV4\StructType\GetVerbandInfoRequest $request_parameters
     * @return \WebApiV4\StructType\GetVerbandInfoResponse|bool
     */
    public function getVerbandInfo(\WebApiV4\StructType\GetVerbandInfoRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getVerbandInfo($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getKenmerkInfo
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \WebApiV4\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Geeft de kenmerken terug die gekoppeld zijn aan een bepaalde relatie.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WebApiV4\StructType\GetKenmerkInfoRequest $request_parameters
     * @return \WebApiV4\StructType\GetKenmerkInfoResponse|bool
     */
    public function getKenmerkInfo(\WebApiV4\StructType\GetKenmerkInfoRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getKenmerkInfo($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getKlantKenmerk
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \WebApiV4\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Controleert of de relatie een opgegeven kenmerk heeft.error5: De relatie is niet gevondenerror19: Er is geen relatie opgegevenerror173: Er is geen kenmerk opgegevenerror174: Het kenmerk is niet gevondenerror178: Er is geen
     * kenmerkgroep opgegevenerror179: De kenmerkgroep is niet gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WebApiV4\StructType\GetKlantKenmerkRequest $request_parameters
     * @return \WebApiV4\StructType\GetKlantKenmerkResponse|bool
     */
    public function getKlantKenmerk(\WebApiV4\StructType\GetKlantKenmerkRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getKlantKenmerk($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSwitchProposities
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \WebApiV4\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Geeft een lijst met proposities terug waar een abonnement naartoe kan switchenerror1: Het abonnement is niet gevondenerror12: Er is geen abonnement opgegevenerror34: De actie is niet gevondenerror57: De actie is niet actieferror84:
     * Voor de abonnee is al een actief abonnement met dezelfde uitgave aanwezig (deze melding kan dus niet optreden als geenControleLopendAbo als 1 meegegeven is in het request)error85: Het is niet mogelijk een proefabonnement aan te makenerror95: De
     * ingangsdatum van de actie is nog niet ingegaanerror96: De einddatum van de actie is verstrekenerror180: Geen geldig switchmogelijkheid gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WebApiV4\StructType\GetSwitchPropositiesRequest $request_parameters
     * @return \WebApiV4\StructType\GetSwitchPropositiesResponse|bool
     */
    public function getSwitchProposities(\WebApiV4\StructType\GetSwitchPropositiesRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getSwitchProposities($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPostcodeInfo
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \WebApiV4\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Geeft de straat en huisnummer terug die behoort bij de opgegeven postcode en huisnumemr combinatie. Deze operatie werkt alleen indien er een postcodetabel van Cendris in Zeno is geimporteerd of gebruik wordt gemaakt van AdresXpress
     * van Cendris of PostcodeApi.nu.</p> <p>Indien gebruik wordt gemaakt van PostcodeApi.nu, wordt geen straat- en plaats gevonden voor postbus-adressen omdat PostcodeApi.nu gebruik maakt van de gegevens uit de Basisadministratie Gemeenten (BAG).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WebApiV4\StructType\GetPostcodeInfoRequest $request_parameters
     * @return \WebApiV4\StructType\GetPostcodeInfoResponse|bool
     */
    public function getPostcodeInfo(\WebApiV4\StructType\GetPostcodeInfoRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getPostcodeInfo($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLeverbareProductenInfo
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \WebApiV4\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Geeft aan welke producten er leverbaar zijn voor de opgegeven relatie.error182: De combinatie postcode/huisnummer is ongeldigerror186: De postcode dient te bestaan uit 4 cijfers gevolgd door een spatie en 2 hoofdletterserror187: Het
     * huisnummer dient geheel te bestaan uit cijfers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WebApiV4\StructType\GetLeverbareProductenInfoRequest $request_parameters
     * @return \WebApiV4\StructType\GetLeverbareProductenInfoResponse|bool
     */
    public function getLeverbareProductenInfo(\WebApiV4\StructType\GetLeverbareProductenInfoRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getLeverbareProductenInfo($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRolInfo
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \WebApiV4\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Geeft alle rollen terug die gedefinieerd zijn voor een bepaalde uitgave
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WebApiV4\StructType\GetRolInfoRequest $request_parameters
     * @return \WebApiV4\StructType\GetRolInfoResponse|bool
     */
    public function getRolInfo(\WebApiV4\StructType\GetRolInfoRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getRolInfo($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLicentiehouders
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \WebApiV4\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Geeft terug wat de licentiehouders van een bepaald abonnement is.error1: Het abonnement is niet gevondenerror238: De licentiehouder is niet gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WebApiV4\StructType\GetLicentiehoudersRequest $request_parameters
     * @return \WebApiV4\StructType\GetLicentiehoudersResponse|bool
     */
    public function getLicentiehouders(\WebApiV4\StructType\GetLicentiehoudersRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getLicentiehouders($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFactSamenvatInfo
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \WebApiV4\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Geeft een lijst met factuur samenvattingen per debiteur relatienummer. <ul><li>Er wordt alleen samenvattende informatie op hoofdlijnen getoond, geen gedetailleerde specificatie per factuur.</li> <li>Deze operatie kan alleen worden
     * aangeroepen als deze is geimplementeerd.</li></ul>error1: Kan geen relatie vinden, er is geen relNo opgegeven.error2: Kan geen relatie vinden obv de opgegeven relNo.error999: Deze functionaliteit is niet geimplementeerd.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WebApiV4\StructType\GetFactSamenvatInfoRequest $request_parameters
     * @return \WebApiV4\StructType\GetFactSamenvatInfoResponse|bool
     */
    public function getFactSamenvatInfo(\WebApiV4\StructType\GetFactSamenvatInfoRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getFactSamenvatInfo($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getToekomstigeMutaties
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \WebApiV4\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Geeft een lijst met toekomstige mutaties per relatienummer. Toekomstige mutaties zijn bijvoorbeeld vakantie regelingen of verhuizingen.error1: Kan geen relatie vinden, er is geen relNo opgegeven.error2: Kan geen relatie vinden obv de
     * opgegeven relNo.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WebApiV4\StructType\GetToekomstigeMutatiesRequest $request_parameters
     * @return \WebApiV4\StructType\GetToekomstigeMutatiesResponse|bool
     */
    public function getToekomstigeMutaties(\WebApiV4\StructType\GetToekomstigeMutatiesRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getToekomstigeMutaties($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getEdities
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \WebApiV4\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Retourneert een lijst van toekomstige (nog niet verschenen) edities. Selectie is mogelijk op basis van een abonnement of een uitgave. Met parameter aantal_edities kan gestuurd worden tot hoeveel toekomstige edities er geretourneerd
     * hoeven worden.error2: Het abonnement is niet gevonden op basis van de opgegeven aboNo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WebApiV4\StructType\GetEditiesRequest $request_parameters
     * @return \WebApiV4\StructType\GetEditiesResponse|bool
     */
    public function getEdities(\WebApiV4\StructType\GetEditiesRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getEdities($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \WebApiV4\StructType\GetAbonnementInfoResponse|\WebApiV4\StructType\GetAbonnementsoortInfoResponse|\WebApiV4\StructType\GetActieInfoResponse|\WebApiV4\StructType\GetCalamiteitInfoByPcHnrResponse|\WebApiV4\StructType\GetCalamiteitInfoResponse|\WebApiV4\StructType\GetEditiesResponse|\WebApiV4\StructType\GetFactSamenvatInfoResponse|\WebApiV4\StructType\GetHerkomstInfoResponse|\WebApiV4\StructType\GetKenmerkInfoResponse|\WebApiV4\StructType\GetKlantKenmerkResponse|\WebApiV4\StructType\GetLeverbareProductenInfoResponse|\WebApiV4\StructType\GetLicentiehoudersResponse|\WebApiV4\StructType\GetPakketInfoResponse|\WebApiV4\StructType\GetPostcodeInfoResponse|\WebApiV4\StructType\GetPropositieInfoResponse|\WebApiV4\StructType\GetRelatieAbosoortPrijsResponse|\WebApiV4\StructType\GetRolInfoResponse|\WebApiV4\StructType\GetSwitchPropositiesResponse|\WebApiV4\StructType\GetToekomstigeMutatiesResponse|\WebApiV4\StructType\GetUitgaveInfoResponse|\WebApiV4\StructType\GetVerbandInfoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
