<?php

namespace WebApiV4\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @subpackage Services
 * @date 20190723
 * @package WebApiV4
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \WebApiV4\StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\WebApiV4\StructType\Authentication $authentication, $nameSpace = 'http://zeno.socho.nl', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named addLicentiehouderRol
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \WebApiV4\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Toevoegen van een rol aan een licentiehouder van een abonnement.error236: De opgegeven rol is niet gevonden bij de uitgave van het abonnementerror238: De licentiehouder is niet gevondenerror247: De opgegeven rol is al gekoppeld bij
     * de licentiehouder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WebApiV4\StructType\AddLicentiehouderRolRequest $request_parameters
     * @return \WebApiV4\StructType\AddLicentiehouderRolResponse|bool
     */
    public function addLicentiehouderRol(\WebApiV4\StructType\AddLicentiehouderRolRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->addLicentiehouderRol($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addLicentiehouder
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \WebApiV4\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Toevoegen van een licentiehouder bij een abonnement.error1: Het abonnement is niet gevonden.error5: De relatie is niet gevonden.error12: Er is geen abonnement opgegeven.error19: Er is geen relatie opgegeven.error236: De opgegeven rol
     * is niet gevonden bij de uitgave van het abonnement.error239: Het abonnement is geen licentieabonnement.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WebApiV4\StructType\AddLicentiehouderRequest $request_parameters
     * @return \WebApiV4\StructType\AddLicentiehouderResponse|bool
     */
    public function addLicentiehouder(\WebApiV4\StructType\AddLicentiehouderRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->addLicentiehouder($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \WebApiV4\StructType\AddLicentiehouderResponse|\WebApiV4\StructType\AddLicentiehouderRolResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
