<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for updateKlantPersoonResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: error219: De opgegeven BIC code hoort niet bij het opgegeven IBAN nummer | error218: Het IBAN nummer dient samen met de BIC code opgegeven te worden | error217: Bij automatische incasso of eenmalige incasso is een IBAN nummer
 * verplicht | error216: De BIC code is ongeldig | error215: Het IBAN nummer is ongeldig | error90: De opgegeven geboortedatum is niet geldig | error63: Het mobiele telefoonnummer is niet geldig | error62: De titulatuur is niet bekend | error38: Het
 * telefoonnummer is niet geldig | error31: Het e-mail adres voldoet niet aan de eisen | error28: Bij een relatie is een naam verplicht | error19: Er is geen relatie opgegeven | error5: De relatie is niet gevonden
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class UpdateKlantPersoonResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The relNoResult
     * Meta informations extracted from the WSDL
     * - documentation: Het relatienummer die bijgewerkt is. Kan afwijken van relNo in het geval dat de relatie is samengevoegd.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relNoResult;
    /**
     * Constructor method for updateKlantPersoonResponse
     * @uses UpdateKlantPersoonResponse::setRequestTag()
     * @uses UpdateKlantPersoonResponse::setRelNoResult()
     * @param string $requestTag
     * @param int $relNoResult
     */
    public function __construct($requestTag = null, $relNoResult = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setRelNoResult($relNoResult);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \WebApiV4\StructType\UpdateKlantPersoonResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get relNoResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelNoResult()
    {
        return isset($this->relNoResult) ? $this->relNoResult : null;
    }
    /**
     * Set relNoResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relNoResult
     * @return \WebApiV4\StructType\UpdateKlantPersoonResponse
     */
    public function setRelNoResult($relNoResult = null)
    {
        // validation for constraint: int
        if (!is_null($relNoResult) && !(is_int($relNoResult) || ctype_digit($relNoResult))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relNoResult, true), gettype($relNoResult)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relNoResult) && mb_strlen(preg_replace('/(\D)/', '', $relNoResult)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relNoResult, true), mb_strlen(preg_replace('/(\D)/', '', $relNoResult))), __LINE__);
        }
        if (is_null($relNoResult) || (is_array($relNoResult) && empty($relNoResult))) {
            unset($this->relNoResult);
        } else {
            $this->relNoResult = $relNoResult;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\UpdateKlantPersoonResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
