<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for updateAboBetaalwijzeRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Een abonnee wil de betaalwijze of het rekeningnummer van zijn bestaande abonnement wijzigen.<br /> In geval het abonnement onderdeel is van een pakket wordt de wijziging voor alle abonnementen behorende tot het pakket doorgevoerd.
 * <br/><u>Let op:</u> bij wijzigingen van een bestaand abonnement dienen alle elementen opnieuw te worden meegegeven. Lege elementen of niet meegegeven (groepen) elementen worden leeg gemaakt door de update.
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class UpdateAboBetaalwijzeRequest extends AbstractStructBase
{
    /**
     * The aboNo
     * Meta informations extracted from the WSDL
     * - documentation: Het abonnementnummer waarvan de betaalwijze veranderd moet worden.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $aboNo;
    /**
     * The aboBetaalwijze
     * Meta informations extracted from the WSDL
     * - documentation: [0,1,3,4,7] Betaalwijze: 0 = factuur, 1 = incasso, 3 = Eenmalige iDeal, 4 = Factuur per mail, 7 = Creditcard.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 38
     * @var float
     */
    public $aboBetaalwijze;
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The aboRekNr
     * Meta informations extracted from the WSDL
     * - documentation: Bankrekeningnummer voor automatische incasso. Gironr begint met P en niet langer dan 7 cijfers, banknr 11-proef. Igv incasso en geen Sepa verplicht.
     * - base: xsd:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboRekNr;
    /**
     * The aboRekIbanNr
     * Meta informations extracted from the WSDL
     * - documentation: IBAN rekeningnummer voor automatische incasso.
     * - base: xsd:string
     * - maxLength: 34
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboRekIbanNr;
    /**
     * The aboRekBicCode
     * Meta informations extracted from the WSDL
     * - documentation: IBAN BIC code voor automatische incasso. Verplicht indien automatische incasso wordt uitgevoerd vanaf een niet Nederlands rekeningnummer.
     * - base: xsd:string
     * - maxLength: 11
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboRekBicCode;
    /**
     * The aboMachtigingsDatum
     * Meta informations extracted from the WSDL
     * - documentation: Datum waarop de incassomachtiging in moet gaan.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboMachtigingsDatum;
    /**
     * The aboBetaalReferentie
     * Meta informations extracted from the WSDL
     * - documentation: Betaalreferentie in geval van betaling via eenmalige iDeal of creditcard.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboBetaalReferentie;
    /**
     * The aboCreditcard
     * Meta informations extracted from the WSDL
     * - documentation: Gegevens van de creditcard in geval van betaalwijze creditcard.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \WebApiV4\StructType\CreditcardV4
     */
    public $aboCreditcard;
    /**
     * The canUpdate
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie of operatie in de testmodus wordt aangeroepen (er wordt dus geen update uitgevoerd) false (Default) = uit, true = aan.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $canUpdate;
    /**
     * Constructor method for updateAboBetaalwijzeRequest
     * @uses UpdateAboBetaalwijzeRequest::setAboNo()
     * @uses UpdateAboBetaalwijzeRequest::setAboBetaalwijze()
     * @uses UpdateAboBetaalwijzeRequest::setRequestTag()
     * @uses UpdateAboBetaalwijzeRequest::setAboRekNr()
     * @uses UpdateAboBetaalwijzeRequest::setAboRekIbanNr()
     * @uses UpdateAboBetaalwijzeRequest::setAboRekBicCode()
     * @uses UpdateAboBetaalwijzeRequest::setAboMachtigingsDatum()
     * @uses UpdateAboBetaalwijzeRequest::setAboBetaalReferentie()
     * @uses UpdateAboBetaalwijzeRequest::setAboCreditcard()
     * @uses UpdateAboBetaalwijzeRequest::setCanUpdate()
     * @param int $aboNo
     * @param float $aboBetaalwijze
     * @param string $requestTag
     * @param string $aboRekNr
     * @param string $aboRekIbanNr
     * @param string $aboRekBicCode
     * @param string $aboMachtigingsDatum
     * @param string $aboBetaalReferentie
     * @param \WebApiV4\StructType\CreditcardV4 $aboCreditcard
     * @param bool $canUpdate
     */
    public function __construct($aboNo = null, $aboBetaalwijze = null, $requestTag = null, $aboRekNr = null, $aboRekIbanNr = null, $aboRekBicCode = null, $aboMachtigingsDatum = null, $aboBetaalReferentie = null, \WebApiV4\StructType\CreditcardV4 $aboCreditcard = null, $canUpdate = null)
    {
        $this
            ->setAboNo($aboNo)
            ->setAboBetaalwijze($aboBetaalwijze)
            ->setRequestTag($requestTag)
            ->setAboRekNr($aboRekNr)
            ->setAboRekIbanNr($aboRekIbanNr)
            ->setAboRekBicCode($aboRekBicCode)
            ->setAboMachtigingsDatum($aboMachtigingsDatum)
            ->setAboBetaalReferentie($aboBetaalReferentie)
            ->setAboCreditcard($aboCreditcard)
            ->setCanUpdate($canUpdate);
    }
    /**
     * Get aboNo value
     * @return int
     */
    public function getAboNo()
    {
        return $this->aboNo;
    }
    /**
     * Set aboNo value
     * @param int $aboNo
     * @return \WebApiV4\StructType\UpdateAboBetaalwijzeRequest
     */
    public function setAboNo($aboNo = null)
    {
        // validation for constraint: int
        if (!is_null($aboNo) && !(is_int($aboNo) || ctype_digit($aboNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aboNo, true), gettype($aboNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($aboNo) && mb_strlen(preg_replace('/(\D)/', '', $aboNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($aboNo, true), mb_strlen(preg_replace('/(\D)/', '', $aboNo))), __LINE__);
        }
        $this->aboNo = $aboNo;
        return $this;
    }
    /**
     * Get aboBetaalwijze value
     * @return float
     */
    public function getAboBetaalwijze()
    {
        return $this->aboBetaalwijze;
    }
    /**
     * Set aboBetaalwijze value
     * @param float $aboBetaalwijze
     * @return \WebApiV4\StructType\UpdateAboBetaalwijzeRequest
     */
    public function setAboBetaalwijze($aboBetaalwijze = null)
    {
        // validation for constraint: float
        if (!is_null($aboBetaalwijze) && !(is_float($aboBetaalwijze) || is_numeric($aboBetaalwijze))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aboBetaalwijze, true), gettype($aboBetaalwijze)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($aboBetaalwijze) && mb_strlen(preg_replace('/(\D)/', '', $aboBetaalwijze)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($aboBetaalwijze, true), mb_strlen(preg_replace('/(\D)/', '', $aboBetaalwijze))), __LINE__);
        }
        $this->aboBetaalwijze = $aboBetaalwijze;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \WebApiV4\StructType\UpdateAboBetaalwijzeRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get aboRekNr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboRekNr()
    {
        return isset($this->aboRekNr) ? $this->aboRekNr : null;
    }
    /**
     * Set aboRekNr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboRekNr
     * @return \WebApiV4\StructType\UpdateAboBetaalwijzeRequest
     */
    public function setAboRekNr($aboRekNr = null)
    {
        // validation for constraint: string
        if (!is_null($aboRekNr) && !is_string($aboRekNr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aboRekNr, true), gettype($aboRekNr)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($aboRekNr) && mb_strlen($aboRekNr) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($aboRekNr)), __LINE__);
        }
        if (is_null($aboRekNr) || (is_array($aboRekNr) && empty($aboRekNr))) {
            unset($this->aboRekNr);
        } else {
            $this->aboRekNr = $aboRekNr;
        }
        return $this;
    }
    /**
     * Get aboRekIbanNr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboRekIbanNr()
    {
        return isset($this->aboRekIbanNr) ? $this->aboRekIbanNr : null;
    }
    /**
     * Set aboRekIbanNr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboRekIbanNr
     * @return \WebApiV4\StructType\UpdateAboBetaalwijzeRequest
     */
    public function setAboRekIbanNr($aboRekIbanNr = null)
    {
        // validation for constraint: string
        if (!is_null($aboRekIbanNr) && !is_string($aboRekIbanNr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aboRekIbanNr, true), gettype($aboRekIbanNr)), __LINE__);
        }
        // validation for constraint: maxLength(34)
        if (!is_null($aboRekIbanNr) && mb_strlen($aboRekIbanNr) > 34) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 34', mb_strlen($aboRekIbanNr)), __LINE__);
        }
        if (is_null($aboRekIbanNr) || (is_array($aboRekIbanNr) && empty($aboRekIbanNr))) {
            unset($this->aboRekIbanNr);
        } else {
            $this->aboRekIbanNr = $aboRekIbanNr;
        }
        return $this;
    }
    /**
     * Get aboRekBicCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboRekBicCode()
    {
        return isset($this->aboRekBicCode) ? $this->aboRekBicCode : null;
    }
    /**
     * Set aboRekBicCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboRekBicCode
     * @return \WebApiV4\StructType\UpdateAboBetaalwijzeRequest
     */
    public function setAboRekBicCode($aboRekBicCode = null)
    {
        // validation for constraint: string
        if (!is_null($aboRekBicCode) && !is_string($aboRekBicCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aboRekBicCode, true), gettype($aboRekBicCode)), __LINE__);
        }
        // validation for constraint: maxLength(11)
        if (!is_null($aboRekBicCode) && mb_strlen($aboRekBicCode) > 11) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 11', mb_strlen($aboRekBicCode)), __LINE__);
        }
        if (is_null($aboRekBicCode) || (is_array($aboRekBicCode) && empty($aboRekBicCode))) {
            unset($this->aboRekBicCode);
        } else {
            $this->aboRekBicCode = $aboRekBicCode;
        }
        return $this;
    }
    /**
     * Get aboMachtigingsDatum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboMachtigingsDatum()
    {
        return isset($this->aboMachtigingsDatum) ? $this->aboMachtigingsDatum : null;
    }
    /**
     * Set aboMachtigingsDatum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboMachtigingsDatum
     * @return \WebApiV4\StructType\UpdateAboBetaalwijzeRequest
     */
    public function setAboMachtigingsDatum($aboMachtigingsDatum = null)
    {
        // validation for constraint: string
        if (!is_null($aboMachtigingsDatum) && !is_string($aboMachtigingsDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aboMachtigingsDatum, true), gettype($aboMachtigingsDatum)), __LINE__);
        }
        if (is_null($aboMachtigingsDatum) || (is_array($aboMachtigingsDatum) && empty($aboMachtigingsDatum))) {
            unset($this->aboMachtigingsDatum);
        } else {
            $this->aboMachtigingsDatum = $aboMachtigingsDatum;
        }
        return $this;
    }
    /**
     * Get aboBetaalReferentie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboBetaalReferentie()
    {
        return isset($this->aboBetaalReferentie) ? $this->aboBetaalReferentie : null;
    }
    /**
     * Set aboBetaalReferentie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboBetaalReferentie
     * @return \WebApiV4\StructType\UpdateAboBetaalwijzeRequest
     */
    public function setAboBetaalReferentie($aboBetaalReferentie = null)
    {
        // validation for constraint: string
        if (!is_null($aboBetaalReferentie) && !is_string($aboBetaalReferentie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aboBetaalReferentie, true), gettype($aboBetaalReferentie)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($aboBetaalReferentie) && mb_strlen($aboBetaalReferentie) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($aboBetaalReferentie)), __LINE__);
        }
        if (is_null($aboBetaalReferentie) || (is_array($aboBetaalReferentie) && empty($aboBetaalReferentie))) {
            unset($this->aboBetaalReferentie);
        } else {
            $this->aboBetaalReferentie = $aboBetaalReferentie;
        }
        return $this;
    }
    /**
     * Get aboCreditcard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \WebApiV4\StructType\CreditcardV4|null
     */
    public function getAboCreditcard()
    {
        return isset($this->aboCreditcard) ? $this->aboCreditcard : null;
    }
    /**
     * Set aboCreditcard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \WebApiV4\StructType\CreditcardV4 $aboCreditcard
     * @return \WebApiV4\StructType\UpdateAboBetaalwijzeRequest
     */
    public function setAboCreditcard(\WebApiV4\StructType\CreditcardV4 $aboCreditcard = null)
    {
        if (is_null($aboCreditcard) || (is_array($aboCreditcard) && empty($aboCreditcard))) {
            unset($this->aboCreditcard);
        } else {
            $this->aboCreditcard = $aboCreditcard;
        }
        return $this;
    }
    /**
     * Get canUpdate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanUpdate()
    {
        return isset($this->canUpdate) ? $this->canUpdate : null;
    }
    /**
     * Set canUpdate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canUpdate
     * @return \WebApiV4\StructType\UpdateAboBetaalwijzeRequest
     */
    public function setCanUpdate($canUpdate = null)
    {
        // validation for constraint: boolean
        if (!is_null($canUpdate) && !is_bool($canUpdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canUpdate, true), gettype($canUpdate)), __LINE__);
        }
        if (is_null($canUpdate) || (is_array($canUpdate) && empty($canUpdate))) {
            unset($this->canUpdate);
        } else {
            $this->canUpdate = $canUpdate;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\UpdateAboBetaalwijzeRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
