<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UitgaveObjectV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Uitgave object t.b.v getLeverbareProducten.
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class UitgaveObjectV4 extends AbstractStructBase
{
    /**
     * The uitgaveCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van de uitgave.
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $uitgaveCode;
    /**
     * The uitgaveNaam
     * Meta informations extracted from the WSDL
     * - documentation: Naam van de uitgave.
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $uitgaveNaam;
    /**
     * The uitgaveReguliereBezorging
     * Meta informations extracted from the WSDL
     * - documentation: Reguliere bezorging mogelijk.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var bool
     */
    public $uitgaveReguliereBezorging;
    /**
     * The uitgavePostBezorging
     * Meta informations extracted from the WSDL
     * - documentation: Post bezorging mogelijk.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var bool
     */
    public $uitgavePostBezorging;
    /**
     * Constructor method for UitgaveObjectV4
     * @uses UitgaveObjectV4::setUitgaveCode()
     * @uses UitgaveObjectV4::setUitgaveNaam()
     * @uses UitgaveObjectV4::setUitgaveReguliereBezorging()
     * @uses UitgaveObjectV4::setUitgavePostBezorging()
     * @param string $uitgaveCode
     * @param string $uitgaveNaam
     * @param bool $uitgaveReguliereBezorging
     * @param bool $uitgavePostBezorging
     */
    public function __construct($uitgaveCode = null, $uitgaveNaam = null, $uitgaveReguliereBezorging = null, $uitgavePostBezorging = null)
    {
        $this
            ->setUitgaveCode($uitgaveCode)
            ->setUitgaveNaam($uitgaveNaam)
            ->setUitgaveReguliereBezorging($uitgaveReguliereBezorging)
            ->setUitgavePostBezorging($uitgavePostBezorging);
    }
    /**
     * Get uitgaveCode value
     * @return string
     */
    public function getUitgaveCode()
    {
        return $this->uitgaveCode;
    }
    /**
     * Set uitgaveCode value
     * @param string $uitgaveCode
     * @return \WebApiV4\StructType\UitgaveObjectV4
     */
    public function setUitgaveCode($uitgaveCode = null)
    {
        // validation for constraint: string
        if (!is_null($uitgaveCode) && !is_string($uitgaveCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uitgaveCode, true), gettype($uitgaveCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($uitgaveCode) && mb_strlen($uitgaveCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($uitgaveCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($uitgaveCode) && mb_strlen($uitgaveCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($uitgaveCode)), __LINE__);
        }
        $this->uitgaveCode = $uitgaveCode;
        return $this;
    }
    /**
     * Get uitgaveNaam value
     * @return string
     */
    public function getUitgaveNaam()
    {
        return $this->uitgaveNaam;
    }
    /**
     * Set uitgaveNaam value
     * @param string $uitgaveNaam
     * @return \WebApiV4\StructType\UitgaveObjectV4
     */
    public function setUitgaveNaam($uitgaveNaam = null)
    {
        // validation for constraint: string
        if (!is_null($uitgaveNaam) && !is_string($uitgaveNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uitgaveNaam, true), gettype($uitgaveNaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($uitgaveNaam) && mb_strlen($uitgaveNaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($uitgaveNaam)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($uitgaveNaam) && mb_strlen($uitgaveNaam) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($uitgaveNaam)), __LINE__);
        }
        $this->uitgaveNaam = $uitgaveNaam;
        return $this;
    }
    /**
     * Get uitgaveReguliereBezorging value
     * @return bool
     */
    public function getUitgaveReguliereBezorging()
    {
        return $this->uitgaveReguliereBezorging;
    }
    /**
     * Set uitgaveReguliereBezorging value
     * @param bool $uitgaveReguliereBezorging
     * @return \WebApiV4\StructType\UitgaveObjectV4
     */
    public function setUitgaveReguliereBezorging($uitgaveReguliereBezorging = null)
    {
        // validation for constraint: boolean
        if (!is_null($uitgaveReguliereBezorging) && !is_bool($uitgaveReguliereBezorging)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($uitgaveReguliereBezorging, true), gettype($uitgaveReguliereBezorging)), __LINE__);
        }
        $this->uitgaveReguliereBezorging = $uitgaveReguliereBezorging;
        return $this;
    }
    /**
     * Get uitgavePostBezorging value
     * @return bool
     */
    public function getUitgavePostBezorging()
    {
        return $this->uitgavePostBezorging;
    }
    /**
     * Set uitgavePostBezorging value
     * @param bool $uitgavePostBezorging
     * @return \WebApiV4\StructType\UitgaveObjectV4
     */
    public function setUitgavePostBezorging($uitgavePostBezorging = null)
    {
        // validation for constraint: boolean
        if (!is_null($uitgavePostBezorging) && !is_bool($uitgavePostBezorging)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($uitgavePostBezorging, true), gettype($uitgavePostBezorging)), __LINE__);
        }
        $this->uitgavePostBezorging = $uitgavePostBezorging;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\UitgaveObjectV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
