<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PropositieInfoV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst met gevonden proposities.
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class PropositieInfoV4 extends AbstractStructBase
{
    /**
     * The proposities
     * Meta informations extracted from the WSDL
     * - documentation: Lijst met gevonden proposities.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \WebApiV4\StructType\PropositiesV4[]
     */
    public $proposities;
    /**
     * Constructor method for PropositieInfoV4
     * @uses PropositieInfoV4::setProposities()
     * @param \WebApiV4\StructType\PropositiesV4[] $proposities
     */
    public function __construct(array $proposities = array())
    {
        $this
            ->setProposities($proposities);
    }
    /**
     * Get proposities value
     * @return \WebApiV4\StructType\PropositiesV4[]|null
     */
    public function getProposities()
    {
        return $this->proposities;
    }
    /**
     * This method is responsible for validating the values passed to the setProposities method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProposities method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePropositiesForArrayConstraintsFromSetProposities(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $propositieInfoV4PropositiesItem) {
            // validation for constraint: itemType
            if (!$propositieInfoV4PropositiesItem instanceof \WebApiV4\StructType\PropositiesV4) {
                $invalidValues[] = is_object($propositieInfoV4PropositiesItem) ? get_class($propositieInfoV4PropositiesItem) : sprintf('%s(%s)', gettype($propositieInfoV4PropositiesItem), var_export($propositieInfoV4PropositiesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The proposities property can only contain items of type \WebApiV4\StructType\PropositiesV4, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set proposities value
     * @throws \InvalidArgumentException
     * @param \WebApiV4\StructType\PropositiesV4[] $proposities
     * @return \WebApiV4\StructType\PropositieInfoV4
     */
    public function setProposities(array $proposities = array())
    {
        // validation for constraint: array
        if ('' !== ($propositiesArrayErrorMessage = self::validatePropositiesForArrayConstraintsFromSetProposities($proposities))) {
            throw new \InvalidArgumentException($propositiesArrayErrorMessage, __LINE__);
        }
        $this->proposities = $proposities;
        return $this;
    }
    /**
     * Add item to proposities value
     * @throws \InvalidArgumentException
     * @param \WebApiV4\StructType\PropositiesV4 $item
     * @return \WebApiV4\StructType\PropositieInfoV4
     */
    public function addToProposities(\WebApiV4\StructType\PropositiesV4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \WebApiV4\StructType\PropositiesV4) {
            throw new \InvalidArgumentException(sprintf('The proposities property can only contain items of type \WebApiV4\StructType\PropositiesV4, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->proposities[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\PropositieInfoV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
