<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KlachtTabV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst klachten.
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class KlachtTabV4 extends AbstractStructBase
{
    /**
     * The klacht
     * Meta informations extracted from the WSDL
     * - documentation: Lijst klachten.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \WebApiV4\StructType\KlachtV4[]
     */
    public $klacht;
    /**
     * Constructor method for KlachtTabV4
     * @uses KlachtTabV4::setKlacht()
     * @param \WebApiV4\StructType\KlachtV4[] $klacht
     */
    public function __construct(array $klacht = array())
    {
        $this
            ->setKlacht($klacht);
    }
    /**
     * Get klacht value
     * @return \WebApiV4\StructType\KlachtV4[]|null
     */
    public function getKlacht()
    {
        return $this->klacht;
    }
    /**
     * This method is responsible for validating the values passed to the setKlacht method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKlacht method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKlachtForArrayConstraintsFromSetKlacht(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $klachtTabV4KlachtItem) {
            // validation for constraint: itemType
            if (!$klachtTabV4KlachtItem instanceof \WebApiV4\StructType\KlachtV4) {
                $invalidValues[] = is_object($klachtTabV4KlachtItem) ? get_class($klachtTabV4KlachtItem) : sprintf('%s(%s)', gettype($klachtTabV4KlachtItem), var_export($klachtTabV4KlachtItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The klacht property can only contain items of type \WebApiV4\StructType\KlachtV4, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set klacht value
     * @throws \InvalidArgumentException
     * @param \WebApiV4\StructType\KlachtV4[] $klacht
     * @return \WebApiV4\StructType\KlachtTabV4
     */
    public function setKlacht(array $klacht = array())
    {
        // validation for constraint: array
        if ('' !== ($klachtArrayErrorMessage = self::validateKlachtForArrayConstraintsFromSetKlacht($klacht))) {
            throw new \InvalidArgumentException($klachtArrayErrorMessage, __LINE__);
        }
        $this->klacht = $klacht;
        return $this;
    }
    /**
     * Add item to klacht value
     * @throws \InvalidArgumentException
     * @param \WebApiV4\StructType\KlachtV4 $item
     * @return \WebApiV4\StructType\KlachtTabV4
     */
    public function addToKlacht(\WebApiV4\StructType\KlachtV4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \WebApiV4\StructType\KlachtV4) {
            throw new \InvalidArgumentException(sprintf('The klacht property can only contain items of type \WebApiV4\StructType\KlachtV4, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->klacht[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\KlachtTabV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
