<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KenmerkInfoV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst met gevonden kenmerken.
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class KenmerkInfoV4 extends AbstractStructBase
{
    /**
     * The kenmerk
     * Meta informations extracted from the WSDL
     * - documentation: Lijst met gevonden kenmerken.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \WebApiV4\StructType\KenmerkV4[]
     */
    public $kenmerk;
    /**
     * Constructor method for KenmerkInfoV4
     * @uses KenmerkInfoV4::setKenmerk()
     * @param \WebApiV4\StructType\KenmerkV4[] $kenmerk
     */
    public function __construct(array $kenmerk = array())
    {
        $this
            ->setKenmerk($kenmerk);
    }
    /**
     * Get kenmerk value
     * @return \WebApiV4\StructType\KenmerkV4[]|null
     */
    public function getKenmerk()
    {
        return $this->kenmerk;
    }
    /**
     * This method is responsible for validating the values passed to the setKenmerk method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKenmerk method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKenmerkForArrayConstraintsFromSetKenmerk(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kenmerkInfoV4KenmerkItem) {
            // validation for constraint: itemType
            if (!$kenmerkInfoV4KenmerkItem instanceof \WebApiV4\StructType\KenmerkV4) {
                $invalidValues[] = is_object($kenmerkInfoV4KenmerkItem) ? get_class($kenmerkInfoV4KenmerkItem) : sprintf('%s(%s)', gettype($kenmerkInfoV4KenmerkItem), var_export($kenmerkInfoV4KenmerkItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The kenmerk property can only contain items of type \WebApiV4\StructType\KenmerkV4, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set kenmerk value
     * @throws \InvalidArgumentException
     * @param \WebApiV4\StructType\KenmerkV4[] $kenmerk
     * @return \WebApiV4\StructType\KenmerkInfoV4
     */
    public function setKenmerk(array $kenmerk = array())
    {
        // validation for constraint: array
        if ('' !== ($kenmerkArrayErrorMessage = self::validateKenmerkForArrayConstraintsFromSetKenmerk($kenmerk))) {
            throw new \InvalidArgumentException($kenmerkArrayErrorMessage, __LINE__);
        }
        $this->kenmerk = $kenmerk;
        return $this;
    }
    /**
     * Add item to kenmerk value
     * @throws \InvalidArgumentException
     * @param \WebApiV4\StructType\KenmerkV4 $item
     * @return \WebApiV4\StructType\KenmerkInfoV4
     */
    public function addToKenmerk(\WebApiV4\StructType\KenmerkV4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \WebApiV4\StructType\KenmerkV4) {
            throw new \InvalidArgumentException(sprintf('The kenmerk property can only contain items of type \WebApiV4\StructType\KenmerkV4, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->kenmerk[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\KenmerkInfoV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
