<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getAbonnementInfoRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Ophalen van abonnements informatie.
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class GetAbonnementInfoRequest extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The relNo
     * Meta informations extracted from the WSDL
     * - documentation: Nummer van de relatie. Dient > 0 te zijn.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relNo;
    /**
     * The toonAbonnementen
     * Meta informations extracted from the WSDL
     * - documentation: Welk type abonnementen moet worden getoond 0=Alleen gewone (default) 1=Alleen licentie 2=Alle abonnementen.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $toonAbonnementen;
    /**
     * The toonHistorie
     * Meta informations extracted from the WSDL
     * - documentation: Geeft aan of ook historische abonnementen moeten worden opgehaald.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $toonHistorie;
    /**
     * Constructor method for getAbonnementInfoRequest
     * @uses GetAbonnementInfoRequest::setRequestTag()
     * @uses GetAbonnementInfoRequest::setRelNo()
     * @uses GetAbonnementInfoRequest::setToonAbonnementen()
     * @uses GetAbonnementInfoRequest::setToonHistorie()
     * @param string $requestTag
     * @param int $relNo
     * @param float $toonAbonnementen
     * @param bool $toonHistorie
     */
    public function __construct($requestTag = null, $relNo = null, $toonAbonnementen = null, $toonHistorie = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setRelNo($relNo)
            ->setToonAbonnementen($toonAbonnementen)
            ->setToonHistorie($toonHistorie);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \WebApiV4\StructType\GetAbonnementInfoRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get relNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelNo()
    {
        return isset($this->relNo) ? $this->relNo : null;
    }
    /**
     * Set relNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relNo
     * @return \WebApiV4\StructType\GetAbonnementInfoRequest
     */
    public function setRelNo($relNo = null)
    {
        // validation for constraint: int
        if (!is_null($relNo) && !(is_int($relNo) || ctype_digit($relNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relNo, true), gettype($relNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relNo) && mb_strlen(preg_replace('/(\D)/', '', $relNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relNo, true), mb_strlen(preg_replace('/(\D)/', '', $relNo))), __LINE__);
        }
        if (is_null($relNo) || (is_array($relNo) && empty($relNo))) {
            unset($this->relNo);
        } else {
            $this->relNo = $relNo;
        }
        return $this;
    }
    /**
     * Get toonAbonnementen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getToonAbonnementen()
    {
        return isset($this->toonAbonnementen) ? $this->toonAbonnementen : null;
    }
    /**
     * Set toonAbonnementen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $toonAbonnementen
     * @return \WebApiV4\StructType\GetAbonnementInfoRequest
     */
    public function setToonAbonnementen($toonAbonnementen = null)
    {
        // validation for constraint: float
        if (!is_null($toonAbonnementen) && !(is_float($toonAbonnementen) || is_numeric($toonAbonnementen))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($toonAbonnementen, true), gettype($toonAbonnementen)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($toonAbonnementen) && mb_strlen(preg_replace('/(\D)/', '', $toonAbonnementen)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($toonAbonnementen, true), mb_strlen(preg_replace('/(\D)/', '', $toonAbonnementen))), __LINE__);
        }
        if (is_null($toonAbonnementen) || (is_array($toonAbonnementen) && empty($toonAbonnementen))) {
            unset($this->toonAbonnementen);
        } else {
            $this->toonAbonnementen = $toonAbonnementen;
        }
        return $this;
    }
    /**
     * Get toonHistorie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getToonHistorie()
    {
        return isset($this->toonHistorie) ? $this->toonHistorie : null;
    }
    /**
     * Set toonHistorie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $toonHistorie
     * @return \WebApiV4\StructType\GetAbonnementInfoRequest
     */
    public function setToonHistorie($toonHistorie = null)
    {
        // validation for constraint: boolean
        if (!is_null($toonHistorie) && !is_bool($toonHistorie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($toonHistorie, true), gettype($toonHistorie)), __LINE__);
        }
        if (is_null($toonHistorie) || (is_array($toonHistorie) && empty($toonHistorie))) {
            unset($this->toonHistorie);
        } else {
            $this->toonHistorie = $toonHistorie;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\GetAbonnementInfoRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
