<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FactSamenvatSubtotInfoV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst met subtotaal regels van een factuur samenvatting.
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class FactSamenvatSubtotInfoV4 extends AbstractStructBase
{
    /**
     * The subtotaal
     * Meta informations extracted from the WSDL
     * - documentation: Lijst met subtotaal regels van een factuur samenvatting.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \WebApiV4\StructType\FactSamenvatSubtotV4[]
     */
    public $subtotaal;
    /**
     * Constructor method for FactSamenvatSubtotInfoV4
     * @uses FactSamenvatSubtotInfoV4::setSubtotaal()
     * @param \WebApiV4\StructType\FactSamenvatSubtotV4[] $subtotaal
     */
    public function __construct(array $subtotaal = array())
    {
        $this
            ->setSubtotaal($subtotaal);
    }
    /**
     * Get subtotaal value
     * @return \WebApiV4\StructType\FactSamenvatSubtotV4[]|null
     */
    public function getSubtotaal()
    {
        return $this->subtotaal;
    }
    /**
     * This method is responsible for validating the values passed to the setSubtotaal method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubtotaal method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubtotaalForArrayConstraintsFromSetSubtotaal(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $factSamenvatSubtotInfoV4SubtotaalItem) {
            // validation for constraint: itemType
            if (!$factSamenvatSubtotInfoV4SubtotaalItem instanceof \WebApiV4\StructType\FactSamenvatSubtotV4) {
                $invalidValues[] = is_object($factSamenvatSubtotInfoV4SubtotaalItem) ? get_class($factSamenvatSubtotInfoV4SubtotaalItem) : sprintf('%s(%s)', gettype($factSamenvatSubtotInfoV4SubtotaalItem), var_export($factSamenvatSubtotInfoV4SubtotaalItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The subtotaal property can only contain items of type \WebApiV4\StructType\FactSamenvatSubtotV4, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set subtotaal value
     * @throws \InvalidArgumentException
     * @param \WebApiV4\StructType\FactSamenvatSubtotV4[] $subtotaal
     * @return \WebApiV4\StructType\FactSamenvatSubtotInfoV4
     */
    public function setSubtotaal(array $subtotaal = array())
    {
        // validation for constraint: array
        if ('' !== ($subtotaalArrayErrorMessage = self::validateSubtotaalForArrayConstraintsFromSetSubtotaal($subtotaal))) {
            throw new \InvalidArgumentException($subtotaalArrayErrorMessage, __LINE__);
        }
        $this->subtotaal = $subtotaal;
        return $this;
    }
    /**
     * Add item to subtotaal value
     * @throws \InvalidArgumentException
     * @param \WebApiV4\StructType\FactSamenvatSubtotV4 $item
     * @return \WebApiV4\StructType\FactSamenvatSubtotInfoV4
     */
    public function addToSubtotaal(\WebApiV4\StructType\FactSamenvatSubtotV4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \WebApiV4\StructType\FactSamenvatSubtotV4) {
            throw new \InvalidArgumentException(sprintf('The subtotaal property can only contain items of type \WebApiV4\StructType\FactSamenvatSubtotV4, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->subtotaal[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\FactSamenvatSubtotInfoV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
