<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createVervolgAbonnementResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: error702: Bij een abonnement is een actie verplicht | error701: Bij een abonnement is een herkomst verplicht | error264: Bij betaalwijze creditcard zijn gegevens van de creditcard verplicht | error263: De opgegeven vrije code 4 is
 * niet bekend | error262: De opgegeven vrije code 2 is niet bekend | error261: De opgegeven vrije code 1 is niet bekend | error260: Een propositiecode dient in combinatie met een actiecode opgegeven te worden | error259: De opgegeven vrije code 3 is
 * niet bekend | error258: Op basis van de opgegeven abosoort/pakket/propositiecode en actiecode zijn meerdere proposities gevonden | error257: De propositie is niet actief | error256: De proposie is niet gevonden | error219: De opgegeven BIC code hoort
 * niet bij het opgegeven IBAN nummer | error218: Het IBAN nummer dient samen met de BIC code opgegeven te worden | error217: Bij automatische incasso of eenmalige incasso is een IBAN nummer verplicht | error216: De BIC code is ongeldig | error215: Het
 * IBAN nummer is ongeldig | error130: Het is niet gelukt om een vervolgabonnement aan te maken | error128: Het pakket is niet gekoppeld aan de actie | error127: De abonnementsoort is niet gekoppeld aan de actie | error107: Het abonnement kan niet
 * aangemaakt worden. Voor de debiteur geldt een leververbod | error99: Het op te volgen abonnement is geen proefabonnement | error98: De premium voor de debiteur is niet gekoppeld aan de propositie | error97: De premium voor de abonnee is niet
 * gekoppeld aan de propositie | error96: De einddatum van de actie is verstreken | error95: De ingangsdatum van de actie is nog niet ingegaan | error92: De abonnementsoort is niet bekend | error91: De premium voor de debiteur is niet actief | error89:
 * Het opgegeven pakket is niet actief | error88: Het opgegeven pakket is niet bekend | error85: Het is niet mogelijk een proefabonnement aan te maken | error84: Voor de abonnee is al een actief abonnement met dezelfde uitgave aanwezig (deze melding kan
 * dus niet optreden als geenControleLopendAbo als 1 meegegeven is in het request) | error58: De premium voor de abonnee is niet actief | error57: De actie is niet actief | error56: De abonnementsoort is niet actief | error36: De herkomst is niet bekend
 * | error35: Het abonnement heeft geen stopeditie | error34: De actie is niet gevonden | error33: Geef of een abonnementsoort- of een pakketcode op | error26: Het opgegeven rekeningnummer voldoet niet | error23: De premium voor de abonnee is niet
 * gevonden | error21: De debiteur is niet gevonden | error19: Er is geen relatie opgegeven | error12: Er is geen abonnement opgegeven | error5: De relatie is niet gevonden | error4: Bij automatische incasso is een rekeningnummer verplicht | error3: De
 * betaalwijze is niet bekend | error1: Het abonnement is niet gevonden
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class CreateVervolgAbonnementResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The aboNoResult
     * Meta informations extracted from the WSDL
     * - documentation: Het abonnementsnummer van het aangemaakte abonnement.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $aboNoResult;
    /**
     * The ingangsDatum
     * Meta informations extracted from the WSDL
     * - documentation: De ingangsdatum van het vervolgabonnement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ingangsDatum;
    /**
     * The machtigingsKenmerk
     * Meta informations extracted from the WSDL
     * - documentation: Door Zeno aangemaakt machtigingskenmerk in geval van betaalwijze SEPA incasso.
     * - base: xsd:string
     * - maxLength: 35
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $machtigingsKenmerk;
    /**
     * Constructor method for createVervolgAbonnementResponse
     * @uses CreateVervolgAbonnementResponse::setRequestTag()
     * @uses CreateVervolgAbonnementResponse::setAboNoResult()
     * @uses CreateVervolgAbonnementResponse::setIngangsDatum()
     * @uses CreateVervolgAbonnementResponse::setMachtigingsKenmerk()
     * @param string $requestTag
     * @param int $aboNoResult
     * @param string $ingangsDatum
     * @param string $machtigingsKenmerk
     */
    public function __construct($requestTag = null, $aboNoResult = null, $ingangsDatum = null, $machtigingsKenmerk = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setAboNoResult($aboNoResult)
            ->setIngangsDatum($ingangsDatum)
            ->setMachtigingsKenmerk($machtigingsKenmerk);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \WebApiV4\StructType\CreateVervolgAbonnementResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get aboNoResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAboNoResult()
    {
        return isset($this->aboNoResult) ? $this->aboNoResult : null;
    }
    /**
     * Set aboNoResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aboNoResult
     * @return \WebApiV4\StructType\CreateVervolgAbonnementResponse
     */
    public function setAboNoResult($aboNoResult = null)
    {
        // validation for constraint: int
        if (!is_null($aboNoResult) && !(is_int($aboNoResult) || ctype_digit($aboNoResult))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aboNoResult, true), gettype($aboNoResult)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($aboNoResult) && mb_strlen(preg_replace('/(\D)/', '', $aboNoResult)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($aboNoResult, true), mb_strlen(preg_replace('/(\D)/', '', $aboNoResult))), __LINE__);
        }
        if (is_null($aboNoResult) || (is_array($aboNoResult) && empty($aboNoResult))) {
            unset($this->aboNoResult);
        } else {
            $this->aboNoResult = $aboNoResult;
        }
        return $this;
    }
    /**
     * Get ingangsDatum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIngangsDatum()
    {
        return isset($this->ingangsDatum) ? $this->ingangsDatum : null;
    }
    /**
     * Set ingangsDatum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ingangsDatum
     * @return \WebApiV4\StructType\CreateVervolgAbonnementResponse
     */
    public function setIngangsDatum($ingangsDatum = null)
    {
        // validation for constraint: string
        if (!is_null($ingangsDatum) && !is_string($ingangsDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ingangsDatum, true), gettype($ingangsDatum)), __LINE__);
        }
        if (is_null($ingangsDatum) || (is_array($ingangsDatum) && empty($ingangsDatum))) {
            unset($this->ingangsDatum);
        } else {
            $this->ingangsDatum = $ingangsDatum;
        }
        return $this;
    }
    /**
     * Get machtigingsKenmerk value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMachtigingsKenmerk()
    {
        return isset($this->machtigingsKenmerk) ? $this->machtigingsKenmerk : null;
    }
    /**
     * Set machtigingsKenmerk value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $machtigingsKenmerk
     * @return \WebApiV4\StructType\CreateVervolgAbonnementResponse
     */
    public function setMachtigingsKenmerk($machtigingsKenmerk = null)
    {
        // validation for constraint: string
        if (!is_null($machtigingsKenmerk) && !is_string($machtigingsKenmerk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($machtigingsKenmerk, true), gettype($machtigingsKenmerk)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($machtigingsKenmerk) && mb_strlen($machtigingsKenmerk) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($machtigingsKenmerk)), __LINE__);
        }
        if (is_null($machtigingsKenmerk) || (is_array($machtigingsKenmerk) && empty($machtigingsKenmerk))) {
            unset($this->machtigingsKenmerk);
        } else {
            $this->machtigingsKenmerk = $machtigingsKenmerk;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\CreateVervolgAbonnementResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
