<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createVerhuizingRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Maakt een verhuizing aan voor een bestaande relatie
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class CreateVerhuizingRequest extends AbstractStructBase
{
    /**
     * The relNo
     * Meta informations extracted from the WSDL
     * - documentation: Nummer van de relatie.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relNo;
    /**
     * The verhuisDatum
     * Meta informations extracted from the WSDL
     * - documentation: Datum per wanneer de verhuizing in moet gaan. Moet in toekomst liggen.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $verhuisDatum;
    /**
     * The adresObjectVerhuis
     * Meta informations extracted from the WSDL
     * - documentation: Adresgegevens van het nieuwe adres.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \WebApiV4\StructType\AdresObjectV4
     */
    public $adresObjectVerhuis;
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The relAdresType
     * Meta informations extracted from the WSDL
     * - documentation: [B,C,P] Adrestype waarvoor de verhuizing geldt. B=Bezoekadres, C=Correspondentieadres, P=Privéadres. Standaard 'B'.
     * - base: xsd:string
     * - maxLength: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $relAdresType;
    /**
     * The canCreate
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie of operatie in de testmodus wordt aangeroepen (er wordt dus geen verhuizing aangemaakt) false (Default) = aanmaken, true = testmodus niet aanmaken.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $canCreate;
    /**
     * Constructor method for createVerhuizingRequest
     * @uses CreateVerhuizingRequest::setRelNo()
     * @uses CreateVerhuizingRequest::setVerhuisDatum()
     * @uses CreateVerhuizingRequest::setAdresObjectVerhuis()
     * @uses CreateVerhuizingRequest::setRequestTag()
     * @uses CreateVerhuizingRequest::setRelAdresType()
     * @uses CreateVerhuizingRequest::setCanCreate()
     * @param int $relNo
     * @param string $verhuisDatum
     * @param \WebApiV4\StructType\AdresObjectV4 $adresObjectVerhuis
     * @param string $requestTag
     * @param string $relAdresType
     * @param bool $canCreate
     */
    public function __construct($relNo = null, $verhuisDatum = null, \WebApiV4\StructType\AdresObjectV4 $adresObjectVerhuis = null, $requestTag = null, $relAdresType = null, $canCreate = null)
    {
        $this
            ->setRelNo($relNo)
            ->setVerhuisDatum($verhuisDatum)
            ->setAdresObjectVerhuis($adresObjectVerhuis)
            ->setRequestTag($requestTag)
            ->setRelAdresType($relAdresType)
            ->setCanCreate($canCreate);
    }
    /**
     * Get relNo value
     * @return int
     */
    public function getRelNo()
    {
        return $this->relNo;
    }
    /**
     * Set relNo value
     * @param int $relNo
     * @return \WebApiV4\StructType\CreateVerhuizingRequest
     */
    public function setRelNo($relNo = null)
    {
        // validation for constraint: int
        if (!is_null($relNo) && !(is_int($relNo) || ctype_digit($relNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relNo, true), gettype($relNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relNo) && mb_strlen(preg_replace('/(\D)/', '', $relNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relNo, true), mb_strlen(preg_replace('/(\D)/', '', $relNo))), __LINE__);
        }
        $this->relNo = $relNo;
        return $this;
    }
    /**
     * Get verhuisDatum value
     * @return string
     */
    public function getVerhuisDatum()
    {
        return $this->verhuisDatum;
    }
    /**
     * Set verhuisDatum value
     * @param string $verhuisDatum
     * @return \WebApiV4\StructType\CreateVerhuizingRequest
     */
    public function setVerhuisDatum($verhuisDatum = null)
    {
        // validation for constraint: string
        if (!is_null($verhuisDatum) && !is_string($verhuisDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($verhuisDatum, true), gettype($verhuisDatum)), __LINE__);
        }
        $this->verhuisDatum = $verhuisDatum;
        return $this;
    }
    /**
     * Get adresObjectVerhuis value
     * @return \WebApiV4\StructType\AdresObjectV4
     */
    public function getAdresObjectVerhuis()
    {
        return $this->adresObjectVerhuis;
    }
    /**
     * Set adresObjectVerhuis value
     * @param \WebApiV4\StructType\AdresObjectV4 $adresObjectVerhuis
     * @return \WebApiV4\StructType\CreateVerhuizingRequest
     */
    public function setAdresObjectVerhuis(\WebApiV4\StructType\AdresObjectV4 $adresObjectVerhuis = null)
    {
        $this->adresObjectVerhuis = $adresObjectVerhuis;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \WebApiV4\StructType\CreateVerhuizingRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get relAdresType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelAdresType()
    {
        return isset($this->relAdresType) ? $this->relAdresType : null;
    }
    /**
     * Set relAdresType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relAdresType
     * @return \WebApiV4\StructType\CreateVerhuizingRequest
     */
    public function setRelAdresType($relAdresType = null)
    {
        // validation for constraint: string
        if (!is_null($relAdresType) && !is_string($relAdresType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relAdresType, true), gettype($relAdresType)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($relAdresType) && mb_strlen($relAdresType) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($relAdresType)), __LINE__);
        }
        if (is_null($relAdresType) || (is_array($relAdresType) && empty($relAdresType))) {
            unset($this->relAdresType);
        } else {
            $this->relAdresType = $relAdresType;
        }
        return $this;
    }
    /**
     * Get canCreate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanCreate()
    {
        return isset($this->canCreate) ? $this->canCreate : null;
    }
    /**
     * Set canCreate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canCreate
     * @return \WebApiV4\StructType\CreateVerhuizingRequest
     */
    public function setCanCreate($canCreate = null)
    {
        // validation for constraint: boolean
        if (!is_null($canCreate) && !is_bool($canCreate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canCreate, true), gettype($canCreate)), __LINE__);
        }
        if (is_null($canCreate) || (is_array($canCreate) && empty($canCreate))) {
            unset($this->canCreate);
        } else {
            $this->canCreate = $canCreate;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\CreateVerhuizingRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
