<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createVerbandR1noR2nawResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: error605: Er zijn meerdere kandidaten gevonden voor relatie 2 | error235: De bij Relatie 2 opgegeven BIC code hoort niet bij het opgegeven IBAN nummer | error234: Bij Relatie 2 dient het IBAN nummer samen met de BIC code opgegeven te
 * worden | error233: De BIC code van Relatie 2 is ongeldig | error232: Het IBAN nummer van Relatie 2 is ongeldig | error170: Er bestaat al een relatieverband tussen relatie 1 en 2 met de opgegeven verbandcode | error169: Het opgegeven geslacht voor
 * relatie 2 is niet geldig | error168: Het adres voor relatie 2 is niet gevonden in de postcodetabel | error167: Titulatuur voor relatie 2 is niet gevonden | error164: Voor de provincie voor relatie 2 is een land verplicht | error163: De provincie voor
 * relatie 2 is niet gekoppeld aan het land | error162: De provincie voor relatie 2 is niet gevonden | error161: Het mobiele telefoonnummer voor relatie 2 is niet geldig | error160: Het telefoonnummer van relatie 2 is niet geldig | error159: Het e-mail
 * adres van relatie 2 voldoet niet aan de eisen | error158: Het adres van relatie 2 is incompleet | error157: Voor relatie 2 ontbreken adresgegevens | error156: Voor relatie 2 ontbreekt de achternaam | error152: Het land voor relatie 2 is niet gevonden
 * | error135: Er is geen verband gevonden met de opgegeven verbandCode | error134: Er is geen verbandCode opgegeven | error37: Er is geen relatienummer van relatie 2 opgegeven | error21: Er is geen relatie gevonden met het relatienummer van relatie 2 |
 * error19: Er is geen relatienummer van relatie 1 opgegeven | error5: Er is geen relatie gevonden met het relatienummer van relatie 1
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class CreateVerbandR1noR2nawResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The isNieuweRelatieRel2
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie of Relatie 2 een nieuwe relatie is of dat er een bestaande relatie gebruikt is.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $isNieuweRelatieRel2;
    /**
     * The relNoRel1Result
     * Meta informations extracted from the WSDL
     * - documentation: Het relatienummer van Relatie 1. (kan afwijken van relNoRel1 input in geval van ontdubbelde relatie).
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relNoRel1Result;
    /**
     * The relNoRel2
     * Meta informations extracted from the WSDL
     * - documentation: Het relatienummer van de nieuwe of bestaande relatie van Relatie 2.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relNoRel2;
    /**
     * The verbandNo
     * Meta informations extracted from the WSDL
     * - documentation: Identifier die het verband tussen Relatie 1 en Relatie 2 uniek identificeert.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $verbandNo;
    /**
     * Constructor method for createVerbandR1noR2nawResponse
     * @uses CreateVerbandR1noR2nawResponse::setRequestTag()
     * @uses CreateVerbandR1noR2nawResponse::setIsNieuweRelatieRel2()
     * @uses CreateVerbandR1noR2nawResponse::setRelNoRel1Result()
     * @uses CreateVerbandR1noR2nawResponse::setRelNoRel2()
     * @uses CreateVerbandR1noR2nawResponse::setVerbandNo()
     * @param string $requestTag
     * @param bool $isNieuweRelatieRel2
     * @param int $relNoRel1Result
     * @param int $relNoRel2
     * @param int $verbandNo
     */
    public function __construct($requestTag = null, $isNieuweRelatieRel2 = null, $relNoRel1Result = null, $relNoRel2 = null, $verbandNo = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setIsNieuweRelatieRel2($isNieuweRelatieRel2)
            ->setRelNoRel1Result($relNoRel1Result)
            ->setRelNoRel2($relNoRel2)
            ->setVerbandNo($verbandNo);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \WebApiV4\StructType\CreateVerbandR1noR2nawResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get isNieuweRelatieRel2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsNieuweRelatieRel2()
    {
        return isset($this->isNieuweRelatieRel2) ? $this->isNieuweRelatieRel2 : null;
    }
    /**
     * Set isNieuweRelatieRel2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isNieuweRelatieRel2
     * @return \WebApiV4\StructType\CreateVerbandR1noR2nawResponse
     */
    public function setIsNieuweRelatieRel2($isNieuweRelatieRel2 = null)
    {
        // validation for constraint: boolean
        if (!is_null($isNieuweRelatieRel2) && !is_bool($isNieuweRelatieRel2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isNieuweRelatieRel2, true), gettype($isNieuweRelatieRel2)), __LINE__);
        }
        if (is_null($isNieuweRelatieRel2) || (is_array($isNieuweRelatieRel2) && empty($isNieuweRelatieRel2))) {
            unset($this->isNieuweRelatieRel2);
        } else {
            $this->isNieuweRelatieRel2 = $isNieuweRelatieRel2;
        }
        return $this;
    }
    /**
     * Get relNoRel1Result value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelNoRel1Result()
    {
        return isset($this->relNoRel1Result) ? $this->relNoRel1Result : null;
    }
    /**
     * Set relNoRel1Result value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relNoRel1Result
     * @return \WebApiV4\StructType\CreateVerbandR1noR2nawResponse
     */
    public function setRelNoRel1Result($relNoRel1Result = null)
    {
        // validation for constraint: int
        if (!is_null($relNoRel1Result) && !(is_int($relNoRel1Result) || ctype_digit($relNoRel1Result))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relNoRel1Result, true), gettype($relNoRel1Result)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relNoRel1Result) && mb_strlen(preg_replace('/(\D)/', '', $relNoRel1Result)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relNoRel1Result, true), mb_strlen(preg_replace('/(\D)/', '', $relNoRel1Result))), __LINE__);
        }
        if (is_null($relNoRel1Result) || (is_array($relNoRel1Result) && empty($relNoRel1Result))) {
            unset($this->relNoRel1Result);
        } else {
            $this->relNoRel1Result = $relNoRel1Result;
        }
        return $this;
    }
    /**
     * Get relNoRel2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelNoRel2()
    {
        return isset($this->relNoRel2) ? $this->relNoRel2 : null;
    }
    /**
     * Set relNoRel2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relNoRel2
     * @return \WebApiV4\StructType\CreateVerbandR1noR2nawResponse
     */
    public function setRelNoRel2($relNoRel2 = null)
    {
        // validation for constraint: int
        if (!is_null($relNoRel2) && !(is_int($relNoRel2) || ctype_digit($relNoRel2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relNoRel2, true), gettype($relNoRel2)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relNoRel2) && mb_strlen(preg_replace('/(\D)/', '', $relNoRel2)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relNoRel2, true), mb_strlen(preg_replace('/(\D)/', '', $relNoRel2))), __LINE__);
        }
        if (is_null($relNoRel2) || (is_array($relNoRel2) && empty($relNoRel2))) {
            unset($this->relNoRel2);
        } else {
            $this->relNoRel2 = $relNoRel2;
        }
        return $this;
    }
    /**
     * Get verbandNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getVerbandNo()
    {
        return isset($this->verbandNo) ? $this->verbandNo : null;
    }
    /**
     * Set verbandNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $verbandNo
     * @return \WebApiV4\StructType\CreateVerbandR1noR2nawResponse
     */
    public function setVerbandNo($verbandNo = null)
    {
        // validation for constraint: int
        if (!is_null($verbandNo) && !(is_int($verbandNo) || ctype_digit($verbandNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($verbandNo, true), gettype($verbandNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($verbandNo) && mb_strlen(preg_replace('/(\D)/', '', $verbandNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($verbandNo, true), mb_strlen(preg_replace('/(\D)/', '', $verbandNo))), __LINE__);
        }
        if (is_null($verbandNo) || (is_array($verbandNo) && empty($verbandNo))) {
            unset($this->verbandNo);
        } else {
            $this->verbandNo = $verbandNo;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\CreateVerbandR1noR2nawResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
