<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for checkProefaboRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Met deze webservice kan worden gecontroleerd of een relatie (obv zijn gegeven e-mail adres of postcode/huisnummer/toevoeging combinatie) al een proefabonnement heeft gehad dat gestart is binnen de afgelopen x maanden. Deze periode is
 * op te geven in de Zeno constantenkaart.
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class CheckProefaboRequest extends AbstractStructBase
{
    /**
     * The uitgave
     * Meta informations extracted from the WSDL
     * - documentation: Code van de uitgave.
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $uitgave;
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The emailAdres
     * Meta informations extracted from the WSDL
     * - documentation: E-mail adres.
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $emailAdres;
    /**
     * The postcode
     * Meta informations extracted from the WSDL
     * - documentation: Postcode.
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $postcode;
    /**
     * The huisnummer
     * Meta informations extracted from the WSDL
     * - documentation: Huisnummer.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $huisnummer;
    /**
     * The huisnummerToevoeging
     * Meta informations extracted from the WSDL
     * - documentation: Huisnummer toevinging.
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $huisnummerToevoeging;
    /**
     * Constructor method for checkProefaboRequest
     * @uses CheckProefaboRequest::setUitgave()
     * @uses CheckProefaboRequest::setRequestTag()
     * @uses CheckProefaboRequest::setEmailAdres()
     * @uses CheckProefaboRequest::setPostcode()
     * @uses CheckProefaboRequest::setHuisnummer()
     * @uses CheckProefaboRequest::setHuisnummerToevoeging()
     * @param string $uitgave
     * @param string $requestTag
     * @param string $emailAdres
     * @param string $postcode
     * @param float $huisnummer
     * @param string $huisnummerToevoeging
     */
    public function __construct($uitgave = null, $requestTag = null, $emailAdres = null, $postcode = null, $huisnummer = null, $huisnummerToevoeging = null)
    {
        $this
            ->setUitgave($uitgave)
            ->setRequestTag($requestTag)
            ->setEmailAdres($emailAdres)
            ->setPostcode($postcode)
            ->setHuisnummer($huisnummer)
            ->setHuisnummerToevoeging($huisnummerToevoeging);
    }
    /**
     * Get uitgave value
     * @return string
     */
    public function getUitgave()
    {
        return $this->uitgave;
    }
    /**
     * Set uitgave value
     * @param string $uitgave
     * @return \WebApiV4\StructType\CheckProefaboRequest
     */
    public function setUitgave($uitgave = null)
    {
        // validation for constraint: string
        if (!is_null($uitgave) && !is_string($uitgave)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uitgave, true), gettype($uitgave)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($uitgave) && mb_strlen($uitgave) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($uitgave)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($uitgave) && mb_strlen($uitgave) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($uitgave)), __LINE__);
        }
        $this->uitgave = $uitgave;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \WebApiV4\StructType\CheckProefaboRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get emailAdres value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailAdres()
    {
        return isset($this->emailAdres) ? $this->emailAdres : null;
    }
    /**
     * Set emailAdres value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailAdres
     * @return \WebApiV4\StructType\CheckProefaboRequest
     */
    public function setEmailAdres($emailAdres = null)
    {
        // validation for constraint: string
        if (!is_null($emailAdres) && !is_string($emailAdres)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailAdres, true), gettype($emailAdres)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($emailAdres) && mb_strlen($emailAdres) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($emailAdres)), __LINE__);
        }
        if (is_null($emailAdres) || (is_array($emailAdres) && empty($emailAdres))) {
            unset($this->emailAdres);
        } else {
            $this->emailAdres = $emailAdres;
        }
        return $this;
    }
    /**
     * Get postcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostcode()
    {
        return isset($this->postcode) ? $this->postcode : null;
    }
    /**
     * Set postcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postcode
     * @return \WebApiV4\StructType\CheckProefaboRequest
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postcode, true), gettype($postcode)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($postcode) && mb_strlen($postcode) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($postcode)), __LINE__);
        }
        if (is_null($postcode) || (is_array($postcode) && empty($postcode))) {
            unset($this->postcode);
        } else {
            $this->postcode = $postcode;
        }
        return $this;
    }
    /**
     * Get huisnummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getHuisnummer()
    {
        return isset($this->huisnummer) ? $this->huisnummer : null;
    }
    /**
     * Set huisnummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $huisnummer
     * @return \WebApiV4\StructType\CheckProefaboRequest
     */
    public function setHuisnummer($huisnummer = null)
    {
        // validation for constraint: float
        if (!is_null($huisnummer) && !(is_float($huisnummer) || is_numeric($huisnummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($huisnummer, true), gettype($huisnummer)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($huisnummer) && mb_strlen(preg_replace('/(\D)/', '', $huisnummer)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($huisnummer, true), mb_strlen(preg_replace('/(\D)/', '', $huisnummer))), __LINE__);
        }
        if (is_null($huisnummer) || (is_array($huisnummer) && empty($huisnummer))) {
            unset($this->huisnummer);
        } else {
            $this->huisnummer = $huisnummer;
        }
        return $this;
    }
    /**
     * Get huisnummerToevoeging value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHuisnummerToevoeging()
    {
        return isset($this->huisnummerToevoeging) ? $this->huisnummerToevoeging : null;
    }
    /**
     * Set huisnummerToevoeging value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $huisnummerToevoeging
     * @return \WebApiV4\StructType\CheckProefaboRequest
     */
    public function setHuisnummerToevoeging($huisnummerToevoeging = null)
    {
        // validation for constraint: string
        if (!is_null($huisnummerToevoeging) && !is_string($huisnummerToevoeging)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($huisnummerToevoeging, true), gettype($huisnummerToevoeging)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($huisnummerToevoeging) && mb_strlen($huisnummerToevoeging) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($huisnummerToevoeging)), __LINE__);
        }
        if (is_null($huisnummerToevoeging) || (is_array($huisnummerToevoeging) && empty($huisnummerToevoeging))) {
            unset($this->huisnummerToevoeging);
        } else {
            $this->huisnummerToevoeging = $huisnummerToevoeging;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\CheckProefaboRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
