<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CalamiteitTabV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst met calamiteiten.
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class CalamiteitTabV4 extends AbstractStructBase
{
    /**
     * The calamiteit
     * Meta informations extracted from the WSDL
     * - documentation: Lijst met calamiteiten.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \WebApiV4\StructType\CalamiteitV4[]
     */
    public $calamiteit;
    /**
     * Constructor method for CalamiteitTabV4
     * @uses CalamiteitTabV4::setCalamiteit()
     * @param \WebApiV4\StructType\CalamiteitV4[] $calamiteit
     */
    public function __construct(array $calamiteit = array())
    {
        $this
            ->setCalamiteit($calamiteit);
    }
    /**
     * Get calamiteit value
     * @return \WebApiV4\StructType\CalamiteitV4[]|null
     */
    public function getCalamiteit()
    {
        return $this->calamiteit;
    }
    /**
     * This method is responsible for validating the values passed to the setCalamiteit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCalamiteit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCalamiteitForArrayConstraintsFromSetCalamiteit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $calamiteitTabV4CalamiteitItem) {
            // validation for constraint: itemType
            if (!$calamiteitTabV4CalamiteitItem instanceof \WebApiV4\StructType\CalamiteitV4) {
                $invalidValues[] = is_object($calamiteitTabV4CalamiteitItem) ? get_class($calamiteitTabV4CalamiteitItem) : sprintf('%s(%s)', gettype($calamiteitTabV4CalamiteitItem), var_export($calamiteitTabV4CalamiteitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The calamiteit property can only contain items of type \WebApiV4\StructType\CalamiteitV4, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set calamiteit value
     * @throws \InvalidArgumentException
     * @param \WebApiV4\StructType\CalamiteitV4[] $calamiteit
     * @return \WebApiV4\StructType\CalamiteitTabV4
     */
    public function setCalamiteit(array $calamiteit = array())
    {
        // validation for constraint: array
        if ('' !== ($calamiteitArrayErrorMessage = self::validateCalamiteitForArrayConstraintsFromSetCalamiteit($calamiteit))) {
            throw new \InvalidArgumentException($calamiteitArrayErrorMessage, __LINE__);
        }
        $this->calamiteit = $calamiteit;
        return $this;
    }
    /**
     * Add item to calamiteit value
     * @throws \InvalidArgumentException
     * @param \WebApiV4\StructType\CalamiteitV4 $item
     * @return \WebApiV4\StructType\CalamiteitTabV4
     */
    public function addToCalamiteit(\WebApiV4\StructType\CalamiteitV4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \WebApiV4\StructType\CalamiteitV4) {
            throw new \InvalidArgumentException(sprintf('The calamiteit property can only contain items of type \WebApiV4\StructType\CalamiteitV4, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->calamiteit[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\CalamiteitTabV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
