<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bestaatActiefAbonnementRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Check op een adres in combinatie met achternaam of daar al een actief abonnement aanwezig is. Deze controle houdt alleen rekening met nederlandse adressen.
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class BestaatActiefAbonnementRequest extends AbstractStructBase
{
    /**
     * The postcode
     * Meta informations extracted from the WSDL
     * - documentation: Postcode.
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $postcode;
    /**
     * The huisNummer
     * Meta informations extracted from the WSDL
     * - documentation: Huisnummer.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 38
     * @var float
     */
    public $huisNummer;
    /**
     * The achternaam
     * Meta informations extracted from the WSDL
     * - documentation: Achternaam van de (abonnee)relatie. Er wordt een match uitgevoerd op uppercase en o.b.v. de 1e 5 karakters.
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $achternaam;
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The huisNummerToevoeging
     * Meta informations extracted from the WSDL
     * - documentation: Huisnummer toevoeging. Match wordt uitgevoerd zonder spaties, '-' en op uppercase. Dit zoek argument is optioneel.
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $huisNummerToevoeging;
    /**
     * Constructor method for bestaatActiefAbonnementRequest
     * @uses BestaatActiefAbonnementRequest::setPostcode()
     * @uses BestaatActiefAbonnementRequest::setHuisNummer()
     * @uses BestaatActiefAbonnementRequest::setAchternaam()
     * @uses BestaatActiefAbonnementRequest::setRequestTag()
     * @uses BestaatActiefAbonnementRequest::setHuisNummerToevoeging()
     * @param string $postcode
     * @param float $huisNummer
     * @param string $achternaam
     * @param string $requestTag
     * @param string $huisNummerToevoeging
     */
    public function __construct($postcode = null, $huisNummer = null, $achternaam = null, $requestTag = null, $huisNummerToevoeging = null)
    {
        $this
            ->setPostcode($postcode)
            ->setHuisNummer($huisNummer)
            ->setAchternaam($achternaam)
            ->setRequestTag($requestTag)
            ->setHuisNummerToevoeging($huisNummerToevoeging);
    }
    /**
     * Get postcode value
     * @return string
     */
    public function getPostcode()
    {
        return $this->postcode;
    }
    /**
     * Set postcode value
     * @param string $postcode
     * @return \WebApiV4\StructType\BestaatActiefAbonnementRequest
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postcode, true), gettype($postcode)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($postcode) && mb_strlen($postcode) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($postcode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($postcode) && mb_strlen($postcode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($postcode)), __LINE__);
        }
        $this->postcode = $postcode;
        return $this;
    }
    /**
     * Get huisNummer value
     * @return float
     */
    public function getHuisNummer()
    {
        return $this->huisNummer;
    }
    /**
     * Set huisNummer value
     * @param float $huisNummer
     * @return \WebApiV4\StructType\BestaatActiefAbonnementRequest
     */
    public function setHuisNummer($huisNummer = null)
    {
        // validation for constraint: float
        if (!is_null($huisNummer) && !(is_float($huisNummer) || is_numeric($huisNummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($huisNummer, true), gettype($huisNummer)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($huisNummer) && mb_strlen(preg_replace('/(\D)/', '', $huisNummer)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($huisNummer, true), mb_strlen(preg_replace('/(\D)/', '', $huisNummer))), __LINE__);
        }
        $this->huisNummer = $huisNummer;
        return $this;
    }
    /**
     * Get achternaam value
     * @return string
     */
    public function getAchternaam()
    {
        return $this->achternaam;
    }
    /**
     * Set achternaam value
     * @param string $achternaam
     * @return \WebApiV4\StructType\BestaatActiefAbonnementRequest
     */
    public function setAchternaam($achternaam = null)
    {
        // validation for constraint: string
        if (!is_null($achternaam) && !is_string($achternaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($achternaam, true), gettype($achternaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($achternaam) && mb_strlen($achternaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($achternaam)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($achternaam) && mb_strlen($achternaam) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($achternaam)), __LINE__);
        }
        $this->achternaam = $achternaam;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \WebApiV4\StructType\BestaatActiefAbonnementRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get huisNummerToevoeging value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHuisNummerToevoeging()
    {
        return isset($this->huisNummerToevoeging) ? $this->huisNummerToevoeging : null;
    }
    /**
     * Set huisNummerToevoeging value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $huisNummerToevoeging
     * @return \WebApiV4\StructType\BestaatActiefAbonnementRequest
     */
    public function setHuisNummerToevoeging($huisNummerToevoeging = null)
    {
        // validation for constraint: string
        if (!is_null($huisNummerToevoeging) && !is_string($huisNummerToevoeging)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($huisNummerToevoeging, true), gettype($huisNummerToevoeging)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($huisNummerToevoeging) && mb_strlen($huisNummerToevoeging) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($huisNummerToevoeging)), __LINE__);
        }
        if (is_null($huisNummerToevoeging) || (is_array($huisNummerToevoeging) && empty($huisNummerToevoeging))) {
            unset($this->huisNummerToevoeging);
        } else {
            $this->huisNummerToevoeging = $huisNummerToevoeging;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\BestaatActiefAbonnementRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
