<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActieInfoV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst met gevonden acties.
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class ActieInfoV4 extends AbstractStructBase
{
    /**
     * The actie
     * Meta informations extracted from the WSDL
     * - documentation: Lijst met gevonden acties.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \WebApiV4\StructType\ActieV4[]
     */
    public $actie;
    /**
     * Constructor method for ActieInfoV4
     * @uses ActieInfoV4::setActie()
     * @param \WebApiV4\StructType\ActieV4[] $actie
     */
    public function __construct(array $actie = array())
    {
        $this
            ->setActie($actie);
    }
    /**
     * Get actie value
     * @return \WebApiV4\StructType\ActieV4[]|null
     */
    public function getActie()
    {
        return $this->actie;
    }
    /**
     * This method is responsible for validating the values passed to the setActie method
     * This method is willingly generated in order to preserve the one-line inline validation within the setActie method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateActieForArrayConstraintsFromSetActie(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $actieInfoV4ActieItem) {
            // validation for constraint: itemType
            if (!$actieInfoV4ActieItem instanceof \WebApiV4\StructType\ActieV4) {
                $invalidValues[] = is_object($actieInfoV4ActieItem) ? get_class($actieInfoV4ActieItem) : sprintf('%s(%s)', gettype($actieInfoV4ActieItem), var_export($actieInfoV4ActieItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The actie property can only contain items of type \WebApiV4\StructType\ActieV4, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set actie value
     * @throws \InvalidArgumentException
     * @param \WebApiV4\StructType\ActieV4[] $actie
     * @return \WebApiV4\StructType\ActieInfoV4
     */
    public function setActie(array $actie = array())
    {
        // validation for constraint: array
        if ('' !== ($actieArrayErrorMessage = self::validateActieForArrayConstraintsFromSetActie($actie))) {
            throw new \InvalidArgumentException($actieArrayErrorMessage, __LINE__);
        }
        $this->actie = $actie;
        return $this;
    }
    /**
     * Add item to actie value
     * @throws \InvalidArgumentException
     * @param \WebApiV4\StructType\ActieV4 $item
     * @return \WebApiV4\StructType\ActieInfoV4
     */
    public function addToActie(\WebApiV4\StructType\ActieV4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \WebApiV4\StructType\ActieV4) {
            throw new \InvalidArgumentException(sprintf('The actie property can only contain items of type \WebApiV4\StructType\ActieV4, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->actie[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\ActieInfoV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
