<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AboPakketInfoV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst met gevonden abonnements pakketten.
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class AboPakketInfoV4 extends AbstractStructBase
{
    /**
     * The aboPakket
     * Meta informations extracted from the WSDL
     * - documentation: Lijst met gevonden abonnements pakketten.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \WebApiV4\StructType\AboPakketV4[]
     */
    public $aboPakket;
    /**
     * Constructor method for AboPakketInfoV4
     * @uses AboPakketInfoV4::setAboPakket()
     * @param \WebApiV4\StructType\AboPakketV4[] $aboPakket
     */
    public function __construct(array $aboPakket = array())
    {
        $this
            ->setAboPakket($aboPakket);
    }
    /**
     * Get aboPakket value
     * @return \WebApiV4\StructType\AboPakketV4[]|null
     */
    public function getAboPakket()
    {
        return $this->aboPakket;
    }
    /**
     * This method is responsible for validating the values passed to the setAboPakket method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAboPakket method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAboPakketForArrayConstraintsFromSetAboPakket(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $aboPakketInfoV4AboPakketItem) {
            // validation for constraint: itemType
            if (!$aboPakketInfoV4AboPakketItem instanceof \WebApiV4\StructType\AboPakketV4) {
                $invalidValues[] = is_object($aboPakketInfoV4AboPakketItem) ? get_class($aboPakketInfoV4AboPakketItem) : sprintf('%s(%s)', gettype($aboPakketInfoV4AboPakketItem), var_export($aboPakketInfoV4AboPakketItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The aboPakket property can only contain items of type \WebApiV4\StructType\AboPakketV4, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set aboPakket value
     * @throws \InvalidArgumentException
     * @param \WebApiV4\StructType\AboPakketV4[] $aboPakket
     * @return \WebApiV4\StructType\AboPakketInfoV4
     */
    public function setAboPakket(array $aboPakket = array())
    {
        // validation for constraint: array
        if ('' !== ($aboPakketArrayErrorMessage = self::validateAboPakketForArrayConstraintsFromSetAboPakket($aboPakket))) {
            throw new \InvalidArgumentException($aboPakketArrayErrorMessage, __LINE__);
        }
        $this->aboPakket = $aboPakket;
        return $this;
    }
    /**
     * Add item to aboPakket value
     * @throws \InvalidArgumentException
     * @param \WebApiV4\StructType\AboPakketV4 $item
     * @return \WebApiV4\StructType\AboPakketInfoV4
     */
    public function addToAboPakket(\WebApiV4\StructType\AboPakketV4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \WebApiV4\StructType\AboPakketV4) {
            throw new \InvalidArgumentException(sprintf('The aboPakket property can only contain items of type \WebApiV4\StructType\AboPakketV4, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->aboPakket[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\AboPakketInfoV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
