<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VerbandV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Gegevens van het gevonden verband
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class VerbandV4 extends AbstractStructBase
{
    /**
     * The relNo1
     * Meta informations extracted from the WSDL
     * - documentation: Nummer van het verband eventueel te gebruiken bij deleteVerband.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relNo1;
    /**
     * The relNo2
     * Meta informations extracted from the WSDL
     * - documentation: Relatienummer van Relatie 1.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relNo2;
    /**
     * The verbandCode
     * Meta informations extracted from the WSDL
     * - documentation: Relatienummer van Relatie 2.
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $verbandCode;
    /**
     * The verbandNo
     * Meta informations extracted from the WSDL
     * - documentation: Code van het verband.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $verbandNo;
    /**
     * Constructor method for VerbandV4
     * @uses VerbandV4::setRelNo1()
     * @uses VerbandV4::setRelNo2()
     * @uses VerbandV4::setVerbandCode()
     * @uses VerbandV4::setVerbandNo()
     * @param int $relNo1
     * @param int $relNo2
     * @param string $verbandCode
     * @param int $verbandNo
     */
    public function __construct($relNo1 = null, $relNo2 = null, $verbandCode = null, $verbandNo = null)
    {
        $this
            ->setRelNo1($relNo1)
            ->setRelNo2($relNo2)
            ->setVerbandCode($verbandCode)
            ->setVerbandNo($verbandNo);
    }
    /**
     * Get relNo1 value
     * @return int
     */
    public function getRelNo1()
    {
        return $this->relNo1;
    }
    /**
     * Set relNo1 value
     * @param int $relNo1
     * @return \WebApiV4\StructType\VerbandV4
     */
    public function setRelNo1($relNo1 = null)
    {
        // validation for constraint: int
        if (!is_null($relNo1) && !(is_int($relNo1) || ctype_digit($relNo1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relNo1, true), gettype($relNo1)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relNo1) && mb_strlen(preg_replace('/(\D)/', '', $relNo1)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relNo1, true), mb_strlen(preg_replace('/(\D)/', '', $relNo1))), __LINE__);
        }
        $this->relNo1 = $relNo1;
        return $this;
    }
    /**
     * Get relNo2 value
     * @return int
     */
    public function getRelNo2()
    {
        return $this->relNo2;
    }
    /**
     * Set relNo2 value
     * @param int $relNo2
     * @return \WebApiV4\StructType\VerbandV4
     */
    public function setRelNo2($relNo2 = null)
    {
        // validation for constraint: int
        if (!is_null($relNo2) && !(is_int($relNo2) || ctype_digit($relNo2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relNo2, true), gettype($relNo2)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relNo2) && mb_strlen(preg_replace('/(\D)/', '', $relNo2)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relNo2, true), mb_strlen(preg_replace('/(\D)/', '', $relNo2))), __LINE__);
        }
        $this->relNo2 = $relNo2;
        return $this;
    }
    /**
     * Get verbandCode value
     * @return string
     */
    public function getVerbandCode()
    {
        return $this->verbandCode;
    }
    /**
     * Set verbandCode value
     * @param string $verbandCode
     * @return \WebApiV4\StructType\VerbandV4
     */
    public function setVerbandCode($verbandCode = null)
    {
        // validation for constraint: string
        if (!is_null($verbandCode) && !is_string($verbandCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($verbandCode, true), gettype($verbandCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($verbandCode) && mb_strlen($verbandCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($verbandCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($verbandCode) && mb_strlen($verbandCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($verbandCode)), __LINE__);
        }
        $this->verbandCode = $verbandCode;
        return $this;
    }
    /**
     * Get verbandNo value
     * @return int
     */
    public function getVerbandNo()
    {
        return $this->verbandNo;
    }
    /**
     * Set verbandNo value
     * @param int $verbandNo
     * @return \WebApiV4\StructType\VerbandV4
     */
    public function setVerbandNo($verbandNo = null)
    {
        // validation for constraint: int
        if (!is_null($verbandNo) && !(is_int($verbandNo) || ctype_digit($verbandNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($verbandNo, true), gettype($verbandNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($verbandNo) && mb_strlen(preg_replace('/(\D)/', '', $verbandNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($verbandNo, true), mb_strlen(preg_replace('/(\D)/', '', $verbandNo))), __LINE__);
        }
        $this->verbandNo = $verbandNo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\VerbandV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
