<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for updateLicentiehouderRolRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Werkt een rol van een licentiehouder bij naar een andere rol
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class UpdateLicentiehouderRolRequest extends AbstractStructBase
{
    /**
     * The licentiehouderRolNo
     * Meta informations extracted from the WSDL
     * - documentation: Nummer van de licentiehouderRol.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $licentiehouderRolNo;
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The rolOmschrijving
     * Meta informations extracted from the WSDL
     * - documentation: Omschrijving van de rol. Indien leeg wordt de relatie zonder rol aangemaakt. Rol moet een bestaande rol bij de uitgave rollen zijn.
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $rolOmschrijving;
    /**
     * Constructor method for updateLicentiehouderRolRequest
     * @uses UpdateLicentiehouderRolRequest::setLicentiehouderRolNo()
     * @uses UpdateLicentiehouderRolRequest::setRequestTag()
     * @uses UpdateLicentiehouderRolRequest::setRolOmschrijving()
     * @param int $licentiehouderRolNo
     * @param string $requestTag
     * @param string $rolOmschrijving
     */
    public function __construct($licentiehouderRolNo = null, $requestTag = null, $rolOmschrijving = null)
    {
        $this
            ->setLicentiehouderRolNo($licentiehouderRolNo)
            ->setRequestTag($requestTag)
            ->setRolOmschrijving($rolOmschrijving);
    }
    /**
     * Get licentiehouderRolNo value
     * @return int
     */
    public function getLicentiehouderRolNo()
    {
        return $this->licentiehouderRolNo;
    }
    /**
     * Set licentiehouderRolNo value
     * @param int $licentiehouderRolNo
     * @return \WebApiV4\StructType\UpdateLicentiehouderRolRequest
     */
    public function setLicentiehouderRolNo($licentiehouderRolNo = null)
    {
        // validation for constraint: int
        if (!is_null($licentiehouderRolNo) && !(is_int($licentiehouderRolNo) || ctype_digit($licentiehouderRolNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($licentiehouderRolNo, true), gettype($licentiehouderRolNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($licentiehouderRolNo) && mb_strlen(preg_replace('/(\D)/', '', $licentiehouderRolNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($licentiehouderRolNo, true), mb_strlen(preg_replace('/(\D)/', '', $licentiehouderRolNo))), __LINE__);
        }
        $this->licentiehouderRolNo = $licentiehouderRolNo;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \WebApiV4\StructType\UpdateLicentiehouderRolRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get rolOmschrijving value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRolOmschrijving()
    {
        return isset($this->rolOmschrijving) ? $this->rolOmschrijving : null;
    }
    /**
     * Set rolOmschrijving value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rolOmschrijving
     * @return \WebApiV4\StructType\UpdateLicentiehouderRolRequest
     */
    public function setRolOmschrijving($rolOmschrijving = null)
    {
        // validation for constraint: string
        if (!is_null($rolOmschrijving) && !is_string($rolOmschrijving)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rolOmschrijving, true), gettype($rolOmschrijving)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($rolOmschrijving) && mb_strlen($rolOmschrijving) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($rolOmschrijving)), __LINE__);
        }
        if (is_null($rolOmschrijving) || (is_array($rolOmschrijving) && empty($rolOmschrijving))) {
            unset($this->rolOmschrijving);
        } else {
            $this->rolOmschrijving = $rolOmschrijving;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\UpdateLicentiehouderRolRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
