<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ToekMutInfoV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst met toekomstige mutaties, zoals bijvoorbeeld verhuizingen of vakantie regelingen.
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class ToekMutInfoV4 extends AbstractStructBase
{
    /**
     * The toekomstigeMutatie
     * Meta informations extracted from the WSDL
     * - documentation: Lijst met toekomstige mutaties.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \WebApiV4\StructType\ToekMutV4[]
     */
    public $toekomstigeMutatie;
    /**
     * Constructor method for ToekMutInfoV4
     * @uses ToekMutInfoV4::setToekomstigeMutatie()
     * @param \WebApiV4\StructType\ToekMutV4[] $toekomstigeMutatie
     */
    public function __construct(array $toekomstigeMutatie = array())
    {
        $this
            ->setToekomstigeMutatie($toekomstigeMutatie);
    }
    /**
     * Get toekomstigeMutatie value
     * @return \WebApiV4\StructType\ToekMutV4[]|null
     */
    public function getToekomstigeMutatie()
    {
        return $this->toekomstigeMutatie;
    }
    /**
     * This method is responsible for validating the values passed to the setToekomstigeMutatie method
     * This method is willingly generated in order to preserve the one-line inline validation within the setToekomstigeMutatie method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateToekomstigeMutatieForArrayConstraintsFromSetToekomstigeMutatie(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $toekMutInfoV4ToekomstigeMutatieItem) {
            // validation for constraint: itemType
            if (!$toekMutInfoV4ToekomstigeMutatieItem instanceof \WebApiV4\StructType\ToekMutV4) {
                $invalidValues[] = is_object($toekMutInfoV4ToekomstigeMutatieItem) ? get_class($toekMutInfoV4ToekomstigeMutatieItem) : sprintf('%s(%s)', gettype($toekMutInfoV4ToekomstigeMutatieItem), var_export($toekMutInfoV4ToekomstigeMutatieItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The toekomstigeMutatie property can only contain items of type \WebApiV4\StructType\ToekMutV4, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set toekomstigeMutatie value
     * @throws \InvalidArgumentException
     * @param \WebApiV4\StructType\ToekMutV4[] $toekomstigeMutatie
     * @return \WebApiV4\StructType\ToekMutInfoV4
     */
    public function setToekomstigeMutatie(array $toekomstigeMutatie = array())
    {
        // validation for constraint: array
        if ('' !== ($toekomstigeMutatieArrayErrorMessage = self::validateToekomstigeMutatieForArrayConstraintsFromSetToekomstigeMutatie($toekomstigeMutatie))) {
            throw new \InvalidArgumentException($toekomstigeMutatieArrayErrorMessage, __LINE__);
        }
        $this->toekomstigeMutatie = $toekomstigeMutatie;
        return $this;
    }
    /**
     * Add item to toekomstigeMutatie value
     * @throws \InvalidArgumentException
     * @param \WebApiV4\StructType\ToekMutV4 $item
     * @return \WebApiV4\StructType\ToekMutInfoV4
     */
    public function addToToekomstigeMutatie(\WebApiV4\StructType\ToekMutV4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \WebApiV4\StructType\ToekMutV4) {
            throw new \InvalidArgumentException(sprintf('The toekomstigeMutatie property can only contain items of type \WebApiV4\StructType\ToekMutV4, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->toekomstigeMutatie[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\ToekMutInfoV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
