<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RolInfoV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst rollen.
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class RolInfoV4 extends AbstractStructBase
{
    /**
     * The rol
     * Meta informations extracted from the WSDL
     * - documentation: Lijst rollen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \WebApiV4\StructType\RolV4[]
     */
    public $rol;
    /**
     * Constructor method for RolInfoV4
     * @uses RolInfoV4::setRol()
     * @param \WebApiV4\StructType\RolV4[] $rol
     */
    public function __construct(array $rol = array())
    {
        $this
            ->setRol($rol);
    }
    /**
     * Get rol value
     * @return \WebApiV4\StructType\RolV4[]|null
     */
    public function getRol()
    {
        return $this->rol;
    }
    /**
     * This method is responsible for validating the values passed to the setRol method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRol method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRolForArrayConstraintsFromSetRol(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rolInfoV4RolItem) {
            // validation for constraint: itemType
            if (!$rolInfoV4RolItem instanceof \WebApiV4\StructType\RolV4) {
                $invalidValues[] = is_object($rolInfoV4RolItem) ? get_class($rolInfoV4RolItem) : sprintf('%s(%s)', gettype($rolInfoV4RolItem), var_export($rolInfoV4RolItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The rol property can only contain items of type \WebApiV4\StructType\RolV4, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set rol value
     * @throws \InvalidArgumentException
     * @param \WebApiV4\StructType\RolV4[] $rol
     * @return \WebApiV4\StructType\RolInfoV4
     */
    public function setRol(array $rol = array())
    {
        // validation for constraint: array
        if ('' !== ($rolArrayErrorMessage = self::validateRolForArrayConstraintsFromSetRol($rol))) {
            throw new \InvalidArgumentException($rolArrayErrorMessage, __LINE__);
        }
        $this->rol = $rol;
        return $this;
    }
    /**
     * Add item to rol value
     * @throws \InvalidArgumentException
     * @param \WebApiV4\StructType\RolV4 $item
     * @return \WebApiV4\StructType\RolInfoV4
     */
    public function addToRol(\WebApiV4\StructType\RolV4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \WebApiV4\StructType\RolV4) {
            throw new \InvalidArgumentException(sprintf('The rol property can only contain items of type \WebApiV4\StructType\RolV4, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->rol[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\RolInfoV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
