<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PropositieTabV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst met proposities.
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class PropositieTabV4 extends AbstractStructBase
{
    /**
     * The propositie
     * Meta informations extracted from the WSDL
     * - documentation: Lijst met proposities.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \WebApiV4\StructType\PropositieObjectV4[]
     */
    public $propositie;
    /**
     * Constructor method for PropositieTabV4
     * @uses PropositieTabV4::setPropositie()
     * @param \WebApiV4\StructType\PropositieObjectV4[] $propositie
     */
    public function __construct(array $propositie = array())
    {
        $this
            ->setPropositie($propositie);
    }
    /**
     * Get propositie value
     * @return \WebApiV4\StructType\PropositieObjectV4[]|null
     */
    public function getPropositie()
    {
        return $this->propositie;
    }
    /**
     * This method is responsible for validating the values passed to the setPropositie method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPropositie method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePropositieForArrayConstraintsFromSetPropositie(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $propositieTabV4PropositieItem) {
            // validation for constraint: itemType
            if (!$propositieTabV4PropositieItem instanceof \WebApiV4\StructType\PropositieObjectV4) {
                $invalidValues[] = is_object($propositieTabV4PropositieItem) ? get_class($propositieTabV4PropositieItem) : sprintf('%s(%s)', gettype($propositieTabV4PropositieItem), var_export($propositieTabV4PropositieItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The propositie property can only contain items of type \WebApiV4\StructType\PropositieObjectV4, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set propositie value
     * @throws \InvalidArgumentException
     * @param \WebApiV4\StructType\PropositieObjectV4[] $propositie
     * @return \WebApiV4\StructType\PropositieTabV4
     */
    public function setPropositie(array $propositie = array())
    {
        // validation for constraint: array
        if ('' !== ($propositieArrayErrorMessage = self::validatePropositieForArrayConstraintsFromSetPropositie($propositie))) {
            throw new \InvalidArgumentException($propositieArrayErrorMessage, __LINE__);
        }
        $this->propositie = $propositie;
        return $this;
    }
    /**
     * Add item to propositie value
     * @throws \InvalidArgumentException
     * @param \WebApiV4\StructType\PropositieObjectV4 $item
     * @return \WebApiV4\StructType\PropositieTabV4
     */
    public function addToPropositie(\WebApiV4\StructType\PropositieObjectV4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \WebApiV4\StructType\PropositieObjectV4) {
            throw new \InvalidArgumentException(sprintf('The propositie property can only contain items of type \WebApiV4\StructType\PropositieObjectV4, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->propositie[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\PropositieTabV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
