<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersoonsObjectV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Het persoonsobject bestaat uit de volgende velden
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class PersoonsObjectV4 extends AbstractStructBase
{
    /**
     * The relNaam
     * Meta informations extracted from the WSDL
     * - documentation: Achternaam.
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $relNaam;
    /**
     * The relEmail
     * Meta informations extracted from the WSDL
     * - documentation: E-mailadres.
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $relEmail;
    /**
     * The relGeboorteDatum
     * Meta informations extracted from the WSDL
     * - documentation: Geboortedatum mag niet langer geleden zijn dan 100 jaar.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $relGeboorteDatum;
    /**
     * The relGeslacht
     * Meta informations extracted from the WSDL
     * - documentation: [0,1,2,3] Geslacht: 0 = n.v.t., 1 = Man, 2 = Vrouw, 3 = Onbekend.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 1
     * @var int
     */
    public $relGeslacht;
    /**
     * The relTelefoon
     * Meta informations extracted from the WSDL
     * - documentation: Telefoonnummer, validatie telefoonnummer indien landcode is leeg.
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $relTelefoon;
    /**
     * The relTelefoonMobiel
     * Meta informations extracted from the WSDL
     * - documentation: Mobiel telefoonnummer, validatie telefoonnummer indien landcode is leeg.
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $relTelefoonMobiel;
    /**
     * The relTitulatuurCode
     * Meta informations extracted from the WSDL
     * - documentation: Bijvoorbeeld Dr. Drs of Ir; Code moet bestaan in de TitulatuurTabel.
     * - base: xsd:string
     * - maxLength: 25
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $relTitulatuurCode;
    /**
     * The relTussenVoegsels
     * Meta informations extracted from the WSDL
     * - documentation: Tussenvoegsels.
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $relTussenVoegsels;
    /**
     * The relVoorletters
     * Meta informations extracted from the WSDL
     * - documentation: Voorletters.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $relVoorletters;
    /**
     * The relVoornaam
     * Meta informations extracted from the WSDL
     * - documentation: Voornaam.
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $relVoornaam;
    /**
     * The relRekNr
     * Meta informations extracted from the WSDL
     * - documentation: Bankrekeningnummer van de klant; Giro begint met P en niet langer dan 7 pos, banknr 11-proef.
     * - base: xsd:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $relRekNr;
    /**
     * The relRekIbanNr
     * Meta informations extracted from the WSDL
     * - documentation: Ibannummer van de bankrekening van de klant; Ibannummer wordt gecontroleerd op valide Iban nummer.
     * - base: xsd:string
     * - maxLength: 34
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $relRekIbanNr;
    /**
     * The relRekBicCode
     * Meta informations extracted from the WSDL
     * - documentation: BicCode van de bankrekening van de klant; Biccode wordt gecontroleerd op valide bic code.
     * - base: xsd:string
     * - maxLength: 11
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $relRekBicCode;
    /**
     * Constructor method for PersoonsObjectV4
     * @uses PersoonsObjectV4::setRelNaam()
     * @uses PersoonsObjectV4::setRelEmail()
     * @uses PersoonsObjectV4::setRelGeboorteDatum()
     * @uses PersoonsObjectV4::setRelGeslacht()
     * @uses PersoonsObjectV4::setRelTelefoon()
     * @uses PersoonsObjectV4::setRelTelefoonMobiel()
     * @uses PersoonsObjectV4::setRelTitulatuurCode()
     * @uses PersoonsObjectV4::setRelTussenVoegsels()
     * @uses PersoonsObjectV4::setRelVoorletters()
     * @uses PersoonsObjectV4::setRelVoornaam()
     * @uses PersoonsObjectV4::setRelRekNr()
     * @uses PersoonsObjectV4::setRelRekIbanNr()
     * @uses PersoonsObjectV4::setRelRekBicCode()
     * @param string $relNaam
     * @param string $relEmail
     * @param string $relGeboorteDatum
     * @param int $relGeslacht
     * @param string $relTelefoon
     * @param string $relTelefoonMobiel
     * @param string $relTitulatuurCode
     * @param string $relTussenVoegsels
     * @param string $relVoorletters
     * @param string $relVoornaam
     * @param string $relRekNr
     * @param string $relRekIbanNr
     * @param string $relRekBicCode
     */
    public function __construct($relNaam = null, $relEmail = null, $relGeboorteDatum = null, $relGeslacht = null, $relTelefoon = null, $relTelefoonMobiel = null, $relTitulatuurCode = null, $relTussenVoegsels = null, $relVoorletters = null, $relVoornaam = null, $relRekNr = null, $relRekIbanNr = null, $relRekBicCode = null)
    {
        $this
            ->setRelNaam($relNaam)
            ->setRelEmail($relEmail)
            ->setRelGeboorteDatum($relGeboorteDatum)
            ->setRelGeslacht($relGeslacht)
            ->setRelTelefoon($relTelefoon)
            ->setRelTelefoonMobiel($relTelefoonMobiel)
            ->setRelTitulatuurCode($relTitulatuurCode)
            ->setRelTussenVoegsels($relTussenVoegsels)
            ->setRelVoorletters($relVoorletters)
            ->setRelVoornaam($relVoornaam)
            ->setRelRekNr($relRekNr)
            ->setRelRekIbanNr($relRekIbanNr)
            ->setRelRekBicCode($relRekBicCode);
    }
    /**
     * Get relNaam value
     * @return string
     */
    public function getRelNaam()
    {
        return $this->relNaam;
    }
    /**
     * Set relNaam value
     * @param string $relNaam
     * @return \WebApiV4\StructType\PersoonsObjectV4
     */
    public function setRelNaam($relNaam = null)
    {
        // validation for constraint: string
        if (!is_null($relNaam) && !is_string($relNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relNaam, true), gettype($relNaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($relNaam) && mb_strlen($relNaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($relNaam)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($relNaam) && mb_strlen($relNaam) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($relNaam)), __LINE__);
        }
        $this->relNaam = $relNaam;
        return $this;
    }
    /**
     * Get relEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelEmail()
    {
        return isset($this->relEmail) ? $this->relEmail : null;
    }
    /**
     * Set relEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relEmail
     * @return \WebApiV4\StructType\PersoonsObjectV4
     */
    public function setRelEmail($relEmail = null)
    {
        // validation for constraint: string
        if (!is_null($relEmail) && !is_string($relEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relEmail, true), gettype($relEmail)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($relEmail) && mb_strlen($relEmail) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($relEmail)), __LINE__);
        }
        if (is_null($relEmail) || (is_array($relEmail) && empty($relEmail))) {
            unset($this->relEmail);
        } else {
            $this->relEmail = $relEmail;
        }
        return $this;
    }
    /**
     * Get relGeboorteDatum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelGeboorteDatum()
    {
        return isset($this->relGeboorteDatum) ? $this->relGeboorteDatum : null;
    }
    /**
     * Set relGeboorteDatum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relGeboorteDatum
     * @return \WebApiV4\StructType\PersoonsObjectV4
     */
    public function setRelGeboorteDatum($relGeboorteDatum = null)
    {
        // validation for constraint: string
        if (!is_null($relGeboorteDatum) && !is_string($relGeboorteDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relGeboorteDatum, true), gettype($relGeboorteDatum)), __LINE__);
        }
        if (is_null($relGeboorteDatum) || (is_array($relGeboorteDatum) && empty($relGeboorteDatum))) {
            unset($this->relGeboorteDatum);
        } else {
            $this->relGeboorteDatum = $relGeboorteDatum;
        }
        return $this;
    }
    /**
     * Get relGeslacht value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelGeslacht()
    {
        return isset($this->relGeslacht) ? $this->relGeslacht : null;
    }
    /**
     * Set relGeslacht value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relGeslacht
     * @return \WebApiV4\StructType\PersoonsObjectV4
     */
    public function setRelGeslacht($relGeslacht = null)
    {
        // validation for constraint: int
        if (!is_null($relGeslacht) && !(is_int($relGeslacht) || ctype_digit($relGeslacht))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relGeslacht, true), gettype($relGeslacht)), __LINE__);
        }
        // validation for constraint: totalDigits(1)
        if (!is_null($relGeslacht) && mb_strlen(preg_replace('/(\D)/', '', $relGeslacht)) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 1 digits, "%d" given', var_export($relGeslacht, true), mb_strlen(preg_replace('/(\D)/', '', $relGeslacht))), __LINE__);
        }
        if (is_null($relGeslacht) || (is_array($relGeslacht) && empty($relGeslacht))) {
            unset($this->relGeslacht);
        } else {
            $this->relGeslacht = $relGeslacht;
        }
        return $this;
    }
    /**
     * Get relTelefoon value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelTelefoon()
    {
        return isset($this->relTelefoon) ? $this->relTelefoon : null;
    }
    /**
     * Set relTelefoon value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relTelefoon
     * @return \WebApiV4\StructType\PersoonsObjectV4
     */
    public function setRelTelefoon($relTelefoon = null)
    {
        // validation for constraint: string
        if (!is_null($relTelefoon) && !is_string($relTelefoon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relTelefoon, true), gettype($relTelefoon)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($relTelefoon) && mb_strlen($relTelefoon) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($relTelefoon)), __LINE__);
        }
        if (is_null($relTelefoon) || (is_array($relTelefoon) && empty($relTelefoon))) {
            unset($this->relTelefoon);
        } else {
            $this->relTelefoon = $relTelefoon;
        }
        return $this;
    }
    /**
     * Get relTelefoonMobiel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelTelefoonMobiel()
    {
        return isset($this->relTelefoonMobiel) ? $this->relTelefoonMobiel : null;
    }
    /**
     * Set relTelefoonMobiel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relTelefoonMobiel
     * @return \WebApiV4\StructType\PersoonsObjectV4
     */
    public function setRelTelefoonMobiel($relTelefoonMobiel = null)
    {
        // validation for constraint: string
        if (!is_null($relTelefoonMobiel) && !is_string($relTelefoonMobiel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relTelefoonMobiel, true), gettype($relTelefoonMobiel)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($relTelefoonMobiel) && mb_strlen($relTelefoonMobiel) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($relTelefoonMobiel)), __LINE__);
        }
        if (is_null($relTelefoonMobiel) || (is_array($relTelefoonMobiel) && empty($relTelefoonMobiel))) {
            unset($this->relTelefoonMobiel);
        } else {
            $this->relTelefoonMobiel = $relTelefoonMobiel;
        }
        return $this;
    }
    /**
     * Get relTitulatuurCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelTitulatuurCode()
    {
        return isset($this->relTitulatuurCode) ? $this->relTitulatuurCode : null;
    }
    /**
     * Set relTitulatuurCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relTitulatuurCode
     * @return \WebApiV4\StructType\PersoonsObjectV4
     */
    public function setRelTitulatuurCode($relTitulatuurCode = null)
    {
        // validation for constraint: string
        if (!is_null($relTitulatuurCode) && !is_string($relTitulatuurCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relTitulatuurCode, true), gettype($relTitulatuurCode)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($relTitulatuurCode) && mb_strlen($relTitulatuurCode) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($relTitulatuurCode)), __LINE__);
        }
        if (is_null($relTitulatuurCode) || (is_array($relTitulatuurCode) && empty($relTitulatuurCode))) {
            unset($this->relTitulatuurCode);
        } else {
            $this->relTitulatuurCode = $relTitulatuurCode;
        }
        return $this;
    }
    /**
     * Get relTussenVoegsels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelTussenVoegsels()
    {
        return isset($this->relTussenVoegsels) ? $this->relTussenVoegsels : null;
    }
    /**
     * Set relTussenVoegsels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relTussenVoegsels
     * @return \WebApiV4\StructType\PersoonsObjectV4
     */
    public function setRelTussenVoegsels($relTussenVoegsels = null)
    {
        // validation for constraint: string
        if (!is_null($relTussenVoegsels) && !is_string($relTussenVoegsels)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relTussenVoegsels, true), gettype($relTussenVoegsels)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($relTussenVoegsels) && mb_strlen($relTussenVoegsels) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($relTussenVoegsels)), __LINE__);
        }
        if (is_null($relTussenVoegsels) || (is_array($relTussenVoegsels) && empty($relTussenVoegsels))) {
            unset($this->relTussenVoegsels);
        } else {
            $this->relTussenVoegsels = $relTussenVoegsels;
        }
        return $this;
    }
    /**
     * Get relVoorletters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelVoorletters()
    {
        return isset($this->relVoorletters) ? $this->relVoorletters : null;
    }
    /**
     * Set relVoorletters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relVoorletters
     * @return \WebApiV4\StructType\PersoonsObjectV4
     */
    public function setRelVoorletters($relVoorletters = null)
    {
        // validation for constraint: string
        if (!is_null($relVoorletters) && !is_string($relVoorletters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relVoorletters, true), gettype($relVoorletters)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($relVoorletters) && mb_strlen($relVoorletters) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($relVoorletters)), __LINE__);
        }
        if (is_null($relVoorletters) || (is_array($relVoorletters) && empty($relVoorletters))) {
            unset($this->relVoorletters);
        } else {
            $this->relVoorletters = $relVoorletters;
        }
        return $this;
    }
    /**
     * Get relVoornaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelVoornaam()
    {
        return isset($this->relVoornaam) ? $this->relVoornaam : null;
    }
    /**
     * Set relVoornaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relVoornaam
     * @return \WebApiV4\StructType\PersoonsObjectV4
     */
    public function setRelVoornaam($relVoornaam = null)
    {
        // validation for constraint: string
        if (!is_null($relVoornaam) && !is_string($relVoornaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relVoornaam, true), gettype($relVoornaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($relVoornaam) && mb_strlen($relVoornaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($relVoornaam)), __LINE__);
        }
        if (is_null($relVoornaam) || (is_array($relVoornaam) && empty($relVoornaam))) {
            unset($this->relVoornaam);
        } else {
            $this->relVoornaam = $relVoornaam;
        }
        return $this;
    }
    /**
     * Get relRekNr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelRekNr()
    {
        return isset($this->relRekNr) ? $this->relRekNr : null;
    }
    /**
     * Set relRekNr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relRekNr
     * @return \WebApiV4\StructType\PersoonsObjectV4
     */
    public function setRelRekNr($relRekNr = null)
    {
        // validation for constraint: string
        if (!is_null($relRekNr) && !is_string($relRekNr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relRekNr, true), gettype($relRekNr)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($relRekNr) && mb_strlen($relRekNr) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($relRekNr)), __LINE__);
        }
        if (is_null($relRekNr) || (is_array($relRekNr) && empty($relRekNr))) {
            unset($this->relRekNr);
        } else {
            $this->relRekNr = $relRekNr;
        }
        return $this;
    }
    /**
     * Get relRekIbanNr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelRekIbanNr()
    {
        return isset($this->relRekIbanNr) ? $this->relRekIbanNr : null;
    }
    /**
     * Set relRekIbanNr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relRekIbanNr
     * @return \WebApiV4\StructType\PersoonsObjectV4
     */
    public function setRelRekIbanNr($relRekIbanNr = null)
    {
        // validation for constraint: string
        if (!is_null($relRekIbanNr) && !is_string($relRekIbanNr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relRekIbanNr, true), gettype($relRekIbanNr)), __LINE__);
        }
        // validation for constraint: maxLength(34)
        if (!is_null($relRekIbanNr) && mb_strlen($relRekIbanNr) > 34) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 34', mb_strlen($relRekIbanNr)), __LINE__);
        }
        if (is_null($relRekIbanNr) || (is_array($relRekIbanNr) && empty($relRekIbanNr))) {
            unset($this->relRekIbanNr);
        } else {
            $this->relRekIbanNr = $relRekIbanNr;
        }
        return $this;
    }
    /**
     * Get relRekBicCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelRekBicCode()
    {
        return isset($this->relRekBicCode) ? $this->relRekBicCode : null;
    }
    /**
     * Set relRekBicCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relRekBicCode
     * @return \WebApiV4\StructType\PersoonsObjectV4
     */
    public function setRelRekBicCode($relRekBicCode = null)
    {
        // validation for constraint: string
        if (!is_null($relRekBicCode) && !is_string($relRekBicCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relRekBicCode, true), gettype($relRekBicCode)), __LINE__);
        }
        // validation for constraint: maxLength(11)
        if (!is_null($relRekBicCode) && mb_strlen($relRekBicCode) > 11) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 11', mb_strlen($relRekBicCode)), __LINE__);
        }
        if (is_null($relRekBicCode) || (is_array($relRekBicCode) && empty($relRekBicCode))) {
            unset($this->relRekBicCode);
        } else {
            $this->relRekBicCode = $relRekBicCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\PersoonsObjectV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
