<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KenmerkV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Kenmerk object.
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class KenmerkV4 extends AbstractStructBase
{
    /**
     * The kenmerkCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van het kenmerk.
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $kenmerkCode;
    /**
     * The kenmerkGroepCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van de kenmerkgroep van het kenmerk.
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $kenmerkGroepCode;
    /**
     * The kenmerkNo
     * Meta informations extracted from the WSDL
     * - documentation: Nummer van het kenmerk, eventueel te gebruiken bij deleteKenmerk.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $kenmerkNo;
    /**
     * The relNo
     * Meta informations extracted from the WSDL
     * - documentation: Nummer van de relatie waaraan het kenmerk gekoppeld is.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relNo;
    /**
     * Constructor method for KenmerkV4
     * @uses KenmerkV4::setKenmerkCode()
     * @uses KenmerkV4::setKenmerkGroepCode()
     * @uses KenmerkV4::setKenmerkNo()
     * @uses KenmerkV4::setRelNo()
     * @param string $kenmerkCode
     * @param string $kenmerkGroepCode
     * @param int $kenmerkNo
     * @param int $relNo
     */
    public function __construct($kenmerkCode = null, $kenmerkGroepCode = null, $kenmerkNo = null, $relNo = null)
    {
        $this
            ->setKenmerkCode($kenmerkCode)
            ->setKenmerkGroepCode($kenmerkGroepCode)
            ->setKenmerkNo($kenmerkNo)
            ->setRelNo($relNo);
    }
    /**
     * Get kenmerkCode value
     * @return string
     */
    public function getKenmerkCode()
    {
        return $this->kenmerkCode;
    }
    /**
     * Set kenmerkCode value
     * @param string $kenmerkCode
     * @return \WebApiV4\StructType\KenmerkV4
     */
    public function setKenmerkCode($kenmerkCode = null)
    {
        // validation for constraint: string
        if (!is_null($kenmerkCode) && !is_string($kenmerkCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kenmerkCode, true), gettype($kenmerkCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($kenmerkCode) && mb_strlen($kenmerkCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($kenmerkCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($kenmerkCode) && mb_strlen($kenmerkCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($kenmerkCode)), __LINE__);
        }
        $this->kenmerkCode = $kenmerkCode;
        return $this;
    }
    /**
     * Get kenmerkGroepCode value
     * @return string
     */
    public function getKenmerkGroepCode()
    {
        return $this->kenmerkGroepCode;
    }
    /**
     * Set kenmerkGroepCode value
     * @param string $kenmerkGroepCode
     * @return \WebApiV4\StructType\KenmerkV4
     */
    public function setKenmerkGroepCode($kenmerkGroepCode = null)
    {
        // validation for constraint: string
        if (!is_null($kenmerkGroepCode) && !is_string($kenmerkGroepCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kenmerkGroepCode, true), gettype($kenmerkGroepCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($kenmerkGroepCode) && mb_strlen($kenmerkGroepCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($kenmerkGroepCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($kenmerkGroepCode) && mb_strlen($kenmerkGroepCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($kenmerkGroepCode)), __LINE__);
        }
        $this->kenmerkGroepCode = $kenmerkGroepCode;
        return $this;
    }
    /**
     * Get kenmerkNo value
     * @return int
     */
    public function getKenmerkNo()
    {
        return $this->kenmerkNo;
    }
    /**
     * Set kenmerkNo value
     * @param int $kenmerkNo
     * @return \WebApiV4\StructType\KenmerkV4
     */
    public function setKenmerkNo($kenmerkNo = null)
    {
        // validation for constraint: int
        if (!is_null($kenmerkNo) && !(is_int($kenmerkNo) || ctype_digit($kenmerkNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kenmerkNo, true), gettype($kenmerkNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($kenmerkNo) && mb_strlen(preg_replace('/(\D)/', '', $kenmerkNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($kenmerkNo, true), mb_strlen(preg_replace('/(\D)/', '', $kenmerkNo))), __LINE__);
        }
        $this->kenmerkNo = $kenmerkNo;
        return $this;
    }
    /**
     * Get relNo value
     * @return int
     */
    public function getRelNo()
    {
        return $this->relNo;
    }
    /**
     * Set relNo value
     * @param int $relNo
     * @return \WebApiV4\StructType\KenmerkV4
     */
    public function setRelNo($relNo = null)
    {
        // validation for constraint: int
        if (!is_null($relNo) && !(is_int($relNo) || ctype_digit($relNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relNo, true), gettype($relNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relNo) && mb_strlen(preg_replace('/(\D)/', '', $relNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relNo, true), mb_strlen(preg_replace('/(\D)/', '', $relNo))), __LINE__);
        }
        $this->relNo = $relNo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\KenmerkV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
