<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HerkomstInfoV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst met herkomsten.
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class HerkomstInfoV4 extends AbstractStructBase
{
    /**
     * The herkomst
     * Meta informations extracted from the WSDL
     * - documentation: Lijst met herkomsten.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \WebApiV4\StructType\HerkomstV4[]
     */
    public $herkomst;
    /**
     * Constructor method for HerkomstInfoV4
     * @uses HerkomstInfoV4::setHerkomst()
     * @param \WebApiV4\StructType\HerkomstV4[] $herkomst
     */
    public function __construct(array $herkomst = array())
    {
        $this
            ->setHerkomst($herkomst);
    }
    /**
     * Get herkomst value
     * @return \WebApiV4\StructType\HerkomstV4[]|null
     */
    public function getHerkomst()
    {
        return $this->herkomst;
    }
    /**
     * This method is responsible for validating the values passed to the setHerkomst method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHerkomst method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHerkomstForArrayConstraintsFromSetHerkomst(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $herkomstInfoV4HerkomstItem) {
            // validation for constraint: itemType
            if (!$herkomstInfoV4HerkomstItem instanceof \WebApiV4\StructType\HerkomstV4) {
                $invalidValues[] = is_object($herkomstInfoV4HerkomstItem) ? get_class($herkomstInfoV4HerkomstItem) : sprintf('%s(%s)', gettype($herkomstInfoV4HerkomstItem), var_export($herkomstInfoV4HerkomstItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The herkomst property can only contain items of type \WebApiV4\StructType\HerkomstV4, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set herkomst value
     * @throws \InvalidArgumentException
     * @param \WebApiV4\StructType\HerkomstV4[] $herkomst
     * @return \WebApiV4\StructType\HerkomstInfoV4
     */
    public function setHerkomst(array $herkomst = array())
    {
        // validation for constraint: array
        if ('' !== ($herkomstArrayErrorMessage = self::validateHerkomstForArrayConstraintsFromSetHerkomst($herkomst))) {
            throw new \InvalidArgumentException($herkomstArrayErrorMessage, __LINE__);
        }
        $this->herkomst = $herkomst;
        return $this;
    }
    /**
     * Add item to herkomst value
     * @throws \InvalidArgumentException
     * @param \WebApiV4\StructType\HerkomstV4 $item
     * @return \WebApiV4\StructType\HerkomstInfoV4
     */
    public function addToHerkomst(\WebApiV4\StructType\HerkomstV4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \WebApiV4\StructType\HerkomstV4) {
            throw new \InvalidArgumentException(sprintf('The herkomst property can only contain items of type \WebApiV4\StructType\HerkomstV4, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->herkomst[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\HerkomstInfoV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
