<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getToekomstigeMutatiesResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: error2: Kan geen relatie vinden obv de opgegeven relNo. | error1: Kan geen relatie vinden, er is geen relNo opgegeven.
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class GetToekomstigeMutatiesResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The toekomstigeMutaties
     * Meta informations extracted from the WSDL
     * - documentation: De lijst met toekomstige mutaties, zoals vakantie regelingen of verhuizingen.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \WebApiV4\StructType\ToekMutInfoV4
     */
    public $toekomstigeMutaties;
    /**
     * Constructor method for getToekomstigeMutatiesResponse
     * @uses GetToekomstigeMutatiesResponse::setRequestTag()
     * @uses GetToekomstigeMutatiesResponse::setToekomstigeMutaties()
     * @param string $requestTag
     * @param \WebApiV4\StructType\ToekMutInfoV4 $toekomstigeMutaties
     */
    public function __construct($requestTag = null, \WebApiV4\StructType\ToekMutInfoV4 $toekomstigeMutaties = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setToekomstigeMutaties($toekomstigeMutaties);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \WebApiV4\StructType\GetToekomstigeMutatiesResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get toekomstigeMutaties value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \WebApiV4\StructType\ToekMutInfoV4|null
     */
    public function getToekomstigeMutaties()
    {
        return isset($this->toekomstigeMutaties) ? $this->toekomstigeMutaties : null;
    }
    /**
     * Set toekomstigeMutaties value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \WebApiV4\StructType\ToekMutInfoV4 $toekomstigeMutaties
     * @return \WebApiV4\StructType\GetToekomstigeMutatiesResponse
     */
    public function setToekomstigeMutaties(\WebApiV4\StructType\ToekMutInfoV4 $toekomstigeMutaties = null)
    {
        if (is_null($toekomstigeMutaties) || (is_array($toekomstigeMutaties) && empty($toekomstigeMutaties))) {
            unset($this->toekomstigeMutaties);
        } else {
            $this->toekomstigeMutaties = $toekomstigeMutaties;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\GetToekomstigeMutatiesResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
