<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getLicentiehoudersResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: error238: De licentiehouder is niet gevonden | error1: Het abonnement is niet gevonden
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class GetLicentiehoudersResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The licentiehoudersInfo
     * Meta informations extracted from the WSDL
     * - documentation: Het object met informatie over de licentiehouders van het abonnement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \WebApiV4\StructType\LicentiehouderInfoV4
     */
    public $licentiehoudersInfo;
    /**
     * Constructor method for getLicentiehoudersResponse
     * @uses GetLicentiehoudersResponse::setRequestTag()
     * @uses GetLicentiehoudersResponse::setLicentiehoudersInfo()
     * @param string $requestTag
     * @param \WebApiV4\StructType\LicentiehouderInfoV4 $licentiehoudersInfo
     */
    public function __construct($requestTag = null, \WebApiV4\StructType\LicentiehouderInfoV4 $licentiehoudersInfo = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setLicentiehoudersInfo($licentiehoudersInfo);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \WebApiV4\StructType\GetLicentiehoudersResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get licentiehoudersInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \WebApiV4\StructType\LicentiehouderInfoV4|null
     */
    public function getLicentiehoudersInfo()
    {
        return isset($this->licentiehoudersInfo) ? $this->licentiehoudersInfo : null;
    }
    /**
     * Set licentiehoudersInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \WebApiV4\StructType\LicentiehouderInfoV4 $licentiehoudersInfo
     * @return \WebApiV4\StructType\GetLicentiehoudersResponse
     */
    public function setLicentiehoudersInfo(\WebApiV4\StructType\LicentiehouderInfoV4 $licentiehoudersInfo = null)
    {
        if (is_null($licentiehoudersInfo) || (is_array($licentiehoudersInfo) && empty($licentiehoudersInfo))) {
            unset($this->licentiehoudersInfo);
        } else {
            $this->licentiehoudersInfo = $licentiehoudersInfo;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\GetLicentiehoudersResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
