<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FactSamenvatInfoV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst met facturen samenvattingen.
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class FactSamenvatInfoV4 extends AbstractStructBase
{
    /**
     * The factuurSamenvatting
     * Meta informations extracted from the WSDL
     * - documentation: Lijst met factuur samenvattingen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \WebApiV4\StructType\FactSamenvatV4[]
     */
    public $factuurSamenvatting;
    /**
     * Constructor method for FactSamenvatInfoV4
     * @uses FactSamenvatInfoV4::setFactuurSamenvatting()
     * @param \WebApiV4\StructType\FactSamenvatV4[] $factuurSamenvatting
     */
    public function __construct(array $factuurSamenvatting = array())
    {
        $this
            ->setFactuurSamenvatting($factuurSamenvatting);
    }
    /**
     * Get factuurSamenvatting value
     * @return \WebApiV4\StructType\FactSamenvatV4[]|null
     */
    public function getFactuurSamenvatting()
    {
        return $this->factuurSamenvatting;
    }
    /**
     * This method is responsible for validating the values passed to the setFactuurSamenvatting method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFactuurSamenvatting method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFactuurSamenvattingForArrayConstraintsFromSetFactuurSamenvatting(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $factSamenvatInfoV4FactuurSamenvattingItem) {
            // validation for constraint: itemType
            if (!$factSamenvatInfoV4FactuurSamenvattingItem instanceof \WebApiV4\StructType\FactSamenvatV4) {
                $invalidValues[] = is_object($factSamenvatInfoV4FactuurSamenvattingItem) ? get_class($factSamenvatInfoV4FactuurSamenvattingItem) : sprintf('%s(%s)', gettype($factSamenvatInfoV4FactuurSamenvattingItem), var_export($factSamenvatInfoV4FactuurSamenvattingItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The factuurSamenvatting property can only contain items of type \WebApiV4\StructType\FactSamenvatV4, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set factuurSamenvatting value
     * @throws \InvalidArgumentException
     * @param \WebApiV4\StructType\FactSamenvatV4[] $factuurSamenvatting
     * @return \WebApiV4\StructType\FactSamenvatInfoV4
     */
    public function setFactuurSamenvatting(array $factuurSamenvatting = array())
    {
        // validation for constraint: array
        if ('' !== ($factuurSamenvattingArrayErrorMessage = self::validateFactuurSamenvattingForArrayConstraintsFromSetFactuurSamenvatting($factuurSamenvatting))) {
            throw new \InvalidArgumentException($factuurSamenvattingArrayErrorMessage, __LINE__);
        }
        $this->factuurSamenvatting = $factuurSamenvatting;
        return $this;
    }
    /**
     * Add item to factuurSamenvatting value
     * @throws \InvalidArgumentException
     * @param \WebApiV4\StructType\FactSamenvatV4 $item
     * @return \WebApiV4\StructType\FactSamenvatInfoV4
     */
    public function addToFactuurSamenvatting(\WebApiV4\StructType\FactSamenvatV4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \WebApiV4\StructType\FactSamenvatV4) {
            throw new \InvalidArgumentException(sprintf('The factuurSamenvatting property can only contain items of type \WebApiV4\StructType\FactSamenvatV4, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->factuurSamenvatting[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\FactSamenvatInfoV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
