<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FactSamenvatBtwInfoV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst met BTW gegevens van de factuur samenvatting.
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class FactSamenvatBtwInfoV4 extends AbstractStructBase
{
    /**
     * The btw
     * Meta informations extracted from the WSDL
     * - documentation: Lijst met btw gegevens van de factuur samenvatting.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \WebApiV4\StructType\FactSamenvatBtwV4[]
     */
    public $btw;
    /**
     * Constructor method for FactSamenvatBtwInfoV4
     * @uses FactSamenvatBtwInfoV4::setBtw()
     * @param \WebApiV4\StructType\FactSamenvatBtwV4[] $btw
     */
    public function __construct(array $btw = array())
    {
        $this
            ->setBtw($btw);
    }
    /**
     * Get btw value
     * @return \WebApiV4\StructType\FactSamenvatBtwV4[]|null
     */
    public function getBtw()
    {
        return $this->btw;
    }
    /**
     * This method is responsible for validating the values passed to the setBtw method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBtw method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBtwForArrayConstraintsFromSetBtw(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $factSamenvatBtwInfoV4BtwItem) {
            // validation for constraint: itemType
            if (!$factSamenvatBtwInfoV4BtwItem instanceof \WebApiV4\StructType\FactSamenvatBtwV4) {
                $invalidValues[] = is_object($factSamenvatBtwInfoV4BtwItem) ? get_class($factSamenvatBtwInfoV4BtwItem) : sprintf('%s(%s)', gettype($factSamenvatBtwInfoV4BtwItem), var_export($factSamenvatBtwInfoV4BtwItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The btw property can only contain items of type \WebApiV4\StructType\FactSamenvatBtwV4, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set btw value
     * @throws \InvalidArgumentException
     * @param \WebApiV4\StructType\FactSamenvatBtwV4[] $btw
     * @return \WebApiV4\StructType\FactSamenvatBtwInfoV4
     */
    public function setBtw(array $btw = array())
    {
        // validation for constraint: array
        if ('' !== ($btwArrayErrorMessage = self::validateBtwForArrayConstraintsFromSetBtw($btw))) {
            throw new \InvalidArgumentException($btwArrayErrorMessage, __LINE__);
        }
        $this->btw = $btw;
        return $this;
    }
    /**
     * Add item to btw value
     * @throws \InvalidArgumentException
     * @param \WebApiV4\StructType\FactSamenvatBtwV4 $item
     * @return \WebApiV4\StructType\FactSamenvatBtwInfoV4
     */
    public function addToBtw(\WebApiV4\StructType\FactSamenvatBtwV4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \WebApiV4\StructType\FactSamenvatBtwV4) {
            throw new \InvalidArgumentException(sprintf('The btw property can only contain items of type \WebApiV4\StructType\FactSamenvatBtwV4, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->btw[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\FactSamenvatBtwInfoV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
