<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for deleteToekomstigeMutatieRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Verwijdert een toekomstige mutatie, zoals een verhuizing of een vakantie regeling.
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class DeleteToekomstigeMutatieRequest extends AbstractStructBase
{
    /**
     * The relNo
     * Meta informations extracted from the WSDL
     * - documentation: Relatienummer bij de te verwijderen toekomstige mutatie.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relNo;
    /**
     * The toekMutNo
     * Meta informations extracted from the WSDL
     * - documentation: Nummer van de te verwijderen toekomstige mutatie.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $toekMutNo;
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The canDelete
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie of operatie in de testmodus wordt aangeroepen (er wordt dus geen delete uitgevoerd) false (Default) = uit, true = aan.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $canDelete;
    /**
     * Constructor method for deleteToekomstigeMutatieRequest
     * @uses DeleteToekomstigeMutatieRequest::setRelNo()
     * @uses DeleteToekomstigeMutatieRequest::setToekMutNo()
     * @uses DeleteToekomstigeMutatieRequest::setRequestTag()
     * @uses DeleteToekomstigeMutatieRequest::setCanDelete()
     * @param int $relNo
     * @param int $toekMutNo
     * @param string $requestTag
     * @param bool $canDelete
     */
    public function __construct($relNo = null, $toekMutNo = null, $requestTag = null, $canDelete = null)
    {
        $this
            ->setRelNo($relNo)
            ->setToekMutNo($toekMutNo)
            ->setRequestTag($requestTag)
            ->setCanDelete($canDelete);
    }
    /**
     * Get relNo value
     * @return int
     */
    public function getRelNo()
    {
        return $this->relNo;
    }
    /**
     * Set relNo value
     * @param int $relNo
     * @return \WebApiV4\StructType\DeleteToekomstigeMutatieRequest
     */
    public function setRelNo($relNo = null)
    {
        // validation for constraint: int
        if (!is_null($relNo) && !(is_int($relNo) || ctype_digit($relNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relNo, true), gettype($relNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relNo) && mb_strlen(preg_replace('/(\D)/', '', $relNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relNo, true), mb_strlen(preg_replace('/(\D)/', '', $relNo))), __LINE__);
        }
        $this->relNo = $relNo;
        return $this;
    }
    /**
     * Get toekMutNo value
     * @return int
     */
    public function getToekMutNo()
    {
        return $this->toekMutNo;
    }
    /**
     * Set toekMutNo value
     * @param int $toekMutNo
     * @return \WebApiV4\StructType\DeleteToekomstigeMutatieRequest
     */
    public function setToekMutNo($toekMutNo = null)
    {
        // validation for constraint: int
        if (!is_null($toekMutNo) && !(is_int($toekMutNo) || ctype_digit($toekMutNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($toekMutNo, true), gettype($toekMutNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($toekMutNo) && mb_strlen(preg_replace('/(\D)/', '', $toekMutNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($toekMutNo, true), mb_strlen(preg_replace('/(\D)/', '', $toekMutNo))), __LINE__);
        }
        $this->toekMutNo = $toekMutNo;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \WebApiV4\StructType\DeleteToekomstigeMutatieRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get canDelete value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanDelete()
    {
        return isset($this->canDelete) ? $this->canDelete : null;
    }
    /**
     * Set canDelete value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canDelete
     * @return \WebApiV4\StructType\DeleteToekomstigeMutatieRequest
     */
    public function setCanDelete($canDelete = null)
    {
        // validation for constraint: boolean
        if (!is_null($canDelete) && !is_bool($canDelete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canDelete, true), gettype($canDelete)), __LINE__);
        }
        if (is_null($canDelete) || (is_array($canDelete) && empty($canDelete))) {
            unset($this->canDelete);
        } else {
            $this->canDelete = $canDelete;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\DeleteToekomstigeMutatieRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
